<?php

use App\Events\ProductUpdatedEvent;
use App\Events\StockGlobalRecalculate;
use App\Events\StockUpdateEvent;
use App\Models\Product;
use App\Models\Test;
use App\Models\OrderLog;
use App\Models\Order;
use App\Daraz\LazopSdk;
use App\Daraz\lazop\Constants;
use App\Daraz\lazop\LazopClient;
use App\Daraz\lazop\LazopRequest;

use Automattic\WooCommerce\Client;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Route;
use shamran\easydaraz\Daraz;

use App\Models\Productarchive; 
use App\Models\Stocktransfer;

use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Arr;

use Codeboxr\PathaoCourier\Facade\PathaoCourier;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

// Route::middleware('auth:api')->get('/user', function (Request $request) {
//     return $request->user();
// });


Route::post('/pathao-hook','api\v1\order\OrderController@pathaoHook');

Route::post('/pathao-hook-test', function (Request $request) {
    return PathaoCourier::order()->orderDetails('DD1512247RNVPE');
});
        
//         $order_no = 'ORD-2024-12-06-1-1';
//         $event = 'Pathao Hook';
//         $message = json_encode($request->all());
        
//         $parts = explode('-', $order_no);
//         $log = new OrderLog();
//         $log->order_no = $order_no;
//         //$log->tracking_no = $tracking_no;
//         $log->outlet = (int)$parts[4];
//         $log->event = $event;
//         $log->message = $message;
//         $log->entry_by = 0;
//         $log->save();
        
//         $common = ['consignment_id','merchant_order_id','order_status','order_status_slug','updated_at','timestamp','store_id','payment_status','invoice_id'];
//         if(isset($request['order_status_slug'])){ // All about order
//             $order_no = $request['merchant_order_id'];
//             $parts = explode('-', $order_no);
            
//             $res = Arr::except($request, $common);
            
            
//             $log = new OrderLog();
//             $log->order_no = $order_no;
//             $log->outlet = (int) $parts[4];
//             $log->event = 'Pathao_'.$request['order_status_slug'];
//             $log->message = json_encode($res);
//             $log->entry_by = 0;
//             $log->save();
            
//             //$res = Arr::except($request, $common);
//         }
//         else if(isset($request['payment_status'])){ // All about payment
//             //$common = ['consignment_id','merchant_order_id','payment_status','invoice_id','updated_at','store_id'];
//         }
//         else{ // Rest Others
//             $res = Arr::except($request, $common);
//         }
// });


Route::get('/test-pathao', function (Request $request) {
    //return PathaoCourier::order()->orderDetails($consignmentId);
    //return $pathao;
        
    return $order['outlet']['pathao_store_id'];
    
        return PathaoCourier::order()
                        ->create([
                            "store_id"            => "28151", // Find in store list,
                            "merchant_order_id"   => "ORD-2024-12-03-6-4", // Unique order id
                            "recipient_name"      => "Mollah Mofiz", // Customer name
                            "recipient_phone"     => "01791767175", // Customer phone
                            "recipient_address"   => "h#31/a, road no 03,  shyamoli, dhaka", // Customer address
                            //"recipient_city"      => "0", // Find in city method
                            //"recipient_zone"      => "0", // Find in zone method
                            //"recipient_area"      => "0", // Find in Area method
                            "delivery_type"       => "48", // 48 for normal delivery or 12 for on demand delivery
                            "item_type"           => "2", // 1 for document, 2 for parcel
                            "special_instruction" => "remarks",
                            "item_quantity"       => "3", // item quantity
                            "item_weight"         => "0.5", // parcel weight
                            "amount_to_collect"   => "830", // amount to collect
                            "item_description"    => "alka" // product details
                        ]);
});

Route::get('/daraz-hook', function (Request $request) {
    $code = $request->query('code');
    
    // Update the .env file with the new value
    $path = base_path('.env');
    if (file_exists($path)) {
        // Update the COUNTER value in the .env file
        file_put_contents(
            $path,
            preg_replace(
                "/^DARAZ_API_APP_CODE=.*/m",
                "DARAZ_API_APP_CODE={$code}",
                file_get_contents($path)
            )
        );
        // Clear the config cache to apply the change
        Artisan::call('config:clear');
    }
    
    //var_dump( 'api code updated');
    
    
    // Start Daraz
    if (!defined("LAZOP_SDK_WORK_DIR"))
    {
    	define("LAZOP_SDK_WORK_DIR", dirname(__FILE__));
    }
    
    if (!defined("LAZOP_AUTOLOADER_PATH"))
    {
    	define("LAZOP_AUTOLOADER_PATH", dirname(__FILE__));
    }
    
    $url = env("DARAZ_API_APP_URL", env("DARAZ_API_APP_URL", "https://api.daraz.com.bd/rest"));
    $key = env("DARAZ_API_APP_KEY", env("DARAZ_API_APP_KEY", "500950"));
    $secret = env("DARAZ_API_APP_SECRET", env("DARAZ_API_APP_SECRET", "53RAcniLiFN8z7keDMAQuhcegtz7sHrs"));
    $tocken = env("DARAZ_API_APP_TOCKEN", env("DARAZ_API_APP_TOCKEN", "50000900620pXdqMlT9LGt0MpgfcIyCK10735553uCVSDZBhpgMR1fjgwmGzyt"));
    $refresh_tocken = env("DARAZ_API_APP_REFRESH_TOCKEN", env("DARAZ_API_APP_REFRESH_TOCKEN", "50001901920efsatwFZFhv8Kr0jJGOGY18356438iTWnDzivoDvO3sppY1PAjH"));
    
    $c = new LazopClient($url, $key, $secret);
    
    // Generate Access Tocken
    $request = new LazopRequest('/auth/token/create');
    $request->addApiParam('code',$code);
    $res = $c->execute($request);
    // Tocken generation
    $tockens = json_decode($res, true);
    $at =  $tockens['access_token'];
    $rt = $tockens['refresh_token'];
    
    // Update the .env file with the new value
    $path = base_path('.env');
    if (file_exists($path)) {
        // Update the COUNTER value in the .env file
        file_put_contents( // set access tocken
            $path,
            preg_replace(
                "/^DARAZ_API_APP_TOCKEN=.*/m",
                "DARAZ_API_APP_TOCKEN={$at}",
                file_get_contents($path)
            )
        );
        file_put_contents(
            $path,
            preg_replace( // set refresh tocken
                "/^DARAZ_API_APP_REFRESH_TOCKEN=.*/m",
                "DARAZ_API_APP_REFRESH_TOCKEN={$rt}",
                file_get_contents($path)
            )
        );
        // Clear the config cache to apply the change
        Artisan::call('config:clear');
    }
    
    echo 'Authenticated Successfully For The Next 30 Days Of Daraz!!!';
});


Route::get('/daraz-sync-all',function(){  
    //exec('composer require paulwscom/lazada-php-sdk');
    //exec('composer dump-autoload');
    //echo 'composer dump-autoload complete';
    if (!defined("LAZOP_SDK_WORK_DIR"))
    {
    	define("LAZOP_SDK_WORK_DIR", dirname(__FILE__));
    }
    
    if (!defined("LAZOP_AUTOLOADER_PATH"))
    {
    	define("LAZOP_AUTOLOADER_PATH", dirname(__FILE__));
    }
    
    $url = env("DARAZ_API_APP_URL", env("DARAZ_API_APP_URL", "https://api.daraz.com.bd/rest"));
    $key = env("DARAZ_API_APP_KEY", env("DARAZ_API_APP_KEY", "500950"));
    $secret = env("DARAZ_API_APP_SECRET", env("DARAZ_API_APP_SECRET", "53RAcniLiFN8z7keDMAQuhcegtz7sHrs"));
    $code = env("DARAZ_API_APP_CODE", env("DARAZ_API_APP_CODE", "4_500950_VzNOTqQad3RVTYNOWBQAnP9i1020"));
    $tocken = env("DARAZ_API_APP_TOCKEN", env("DARAZ_API_APP_TOCKEN", "50000900620pXdqMlT9LGt0MpgfcIyCK10735553uCVSDZBhpgMR1fjgwmGzyt"));
    $refresh_tocken = env("DARAZ_API_APP_REFRESH_TOCKEN", env("DARAZ_API_APP_REFRESH_TOCKEN", "50001901920efsatwFZFhv8Kr0jJGOGY18356438iTWnDzivoDvO3sppY1PAjH"));
    
    $c = new LazopClient($url, $key, $secret);
    
// Generate Access Tocken
    // $request = new LazopRequest('/auth/token/create');
    // $request->addApiParam('code',$code);
    // var_dump($c->execute($request));
    // dd($c->execute($request));
// Tocken generation
    
    $request = new LazopRequest('/products/get','GET');
    for($i=0;$i<300;$i+=10){ 
        echo $i;
        $request->addApiParam('filter','live');
        $request->addApiParam('offset',$i);
        $request->addApiParam('limit',10);
        // //$request->addApiParam('sku_seller_list',json_encode(["HF-582-22"])); //HF-582-22
        $r = json_decode($c->execute($request, $tocken));
        if(isset($r->data->total_products)){
            $products = $r->data->products;
            foreach ($products as $k => $p) {
                $pid = $p->item_id;
                $skus = $p->skus;
                foreach($skus as $key=>$sku){
                    $stock = Productarchive::where('code',$sku->SellerSku)->where('status',3)->count('barcode');
                    // $r2p['Product']['Skus']['sku']['ItemId'] = $pid;
                    // $r2p['Product']['Skus']['sku']['SkuId'] = $sku->SkuId;
                    // $r2p['Product']['Skus']['sku']['SellerSku'] = $sku->SellerSku;
                    // $r2p['Product']['Skus']['sku']['Quantity'] = $stock;
                    $ssku = $sku->SellerSku;
                    $sskuid = $sku->SkuId;
                    $xml = new SimpleXMLElement('<Request/>');
                    $product = $xml->addChild('Product');
                    $skus = $product->addChild('Skus');
                    $sku = $skus->addChild('Sku');
                    $sku->addChild('SellerSku', $ssku);
                    $sku->addChild('SkuId', $sskuid);
                    $sku->addChild('Quantity', $stock);
                    $r2 = new LazopRequest('/product/price_quantity/update');
                    $r2->addApiParam('payload',$xml->asXML()); 
                    $r2r = json_decode($c->execute($r2, $tocken));
                    echo $sku->SellerSku.'----:'.$stock.'<br/>';
                    print_r($r2r);
                    //break;
                    sleep(2);
                    
                    //usleep(5000);
                    
                }
                
            }
        
        }
        else{
            return 'not found';
        }
    }

    
    
    //dd($c);
    // $url = env("DARAZ_URL", env("DARAZ_URL", "https://api.sellercenter.daraz.com.bd"));
    //     $userId = env("DARAZ_USER_ID", env("DARAZ_USER_ID", "digantawear@gmail.com"));
    //     $apiKey = env("DARAZ_API_KEY", env("DARAZ_API_KEY", "9fd28t8Iiz5OlGhejTD7kNELllvdZFrnVqwi7z2xKpRkEFc7JyG_yi5o"));
    //     $daraz = new Daraz($userId, $apiKey, $url);
    //     $code = 'HF-596-20';
    //     $stock = Productarchive::where('code',$code)->where('status',3)->count('barcode');

    //     //Fetch SKU From Daraz
    //     $arr = json_encode([$code]);
    //     print_r($arr) ;
    //     $result = $daraz->getProducts('live',null,null,null,null,null,null,null,null,$arr);
    //     print_r($result) ;
    //     if(isset($result['response']['SuccessResponse']['Body']['TotalProducts'])){
    //         $product = $result['response']['SuccessResponse']['Body']['Products'];
    //         foreach ($product[0]['Skus'] as $key => $sku) {
    //             if($sku['SellerSku']==$code){ // Variation Found
    //                 $product[0]['Skus'][$key]['quantity'] = 5;
    //                 $update_stock_arr['Product']['Skus']['sku']['SellerSku'] = $sku['SellerSku'];
    //                 $update_stock_arr['Product']['Skus']['sku']['Quantity'] = $stock;
    //                 $daraz->updatePriceQuantity($update_stock_arr);
    //             }
    //         }
            
    //     }
    //     else{
    //         echo 'No Product Found';
    //     }
    //set_time_limit(300);
    
    
    
    // $url = env("DARAZ_URL", env("DARAZ_URL", "https://api.sellercenter.daraz.com.bd"));
    //     $userId = env("DARAZ_USER_ID", env("DARAZ_USER_ID", "digantawear@gmail.com"));
    //     $apiKey = env("DARAZ_API_KEY", env("DARAZ_API_KEY", "83102c109b0b59619a74b3006e8dbb3c497b61f3"));

    //     $daraz = new Daraz($userId, $apiKey, $url); //SellerSku
    //     //dd($d->getAllProducts());
        
    //     //echo $stock;
    //     //$arr = json_encode([$code]);
    //     $offset = 0;
    //     $limit = 30;
    //     $result = $daraz->getProducts(null,null,null,null,null,null,$limit,null,$offset,null);
    //     //dd($result);
    //     if(isset($result['response']['SuccessResponse']['Body']['TotalProducts'])){
    //         $product = $result['response']['SuccessResponse']['Body']['Products'];
    //         foreach ($product as $k => $p) {
    //             //echo json_encode($product[$k]['Skus']).'<br/>';
    //             foreach ($product[$k]['Skus'] as $key => $sku) {
    //                 $stock = Productarchive::where('code',$sku['SellerSku'])->where('status',3)->count('barcode');
    //                 $update_stock_arr['Product']['Skus']['sku']['SellerSku'] = $sku['SellerSku'];
    //                 $update_stock_arr['Product']['Skus']['sku']['Quantity'] = $stock;
    //                 echo json_encode($sku['SellerSku']).'<br/>';
    //                 $daraz->updatePriceQuantity($update_stock_arr);
    //             }
    //         }
            
    //     }
    //     else{
    //         echo 'No Product Found';
    //     }
    
    
    
    
    
    //$pros = Productarchive::where('status',3)->where('audit_outlet_id',0)->get();
        // $pros = Productarchive::where('audit_at','2022-04-07 01:45:36')->where('status',3)->get();
        // $c=0;
        // foreach($pros as $key=>$pr){
            
        //         $prod = Productarchive::find($pr->id);
        //         //$prod->audit_outlet_id = $prod->outlet_id;
        //         //$prod->audit_outlet_name = $prod->outlet_name;
        //         //$prod->audit_at = now();
        //         $prod->status = 420;
        //         $prod->save();
        //         echo $pr->barcode.'<br/>';
        // }
    
    
    // $transfers = Stocktransfer::whereDate('confirmed_date','>','2022-01-10')->get();
    //     $c = 0;
    //     foreach($transfers as $key=>$tr){
    //         foreach($tr->items as $k=>$it){
    //             $bid = $it['id'];
    //             $barcode =  $it['barcode'];
    //             $to_id = $tr['transfer_to'];
    //             $to_name = $tr['to_name'];

    //             $pr = Productarchive::find($bid);
    //             if($pr->audit_outlet_id ==0){
    //                 $pr->audit_outlet_id = $to_id;
    //                 $pr->audit_outlet_name = $to_name;
    //                 $pr->audit_at = now();
    //                 $pr->save();
    //                 echo ++$c.'#'.$pr->barcode.'<br/>';
    //             }
                
    //         }
    //     }
        
        ///////////
    // $pros = Productarchive::select('id','barcode','audit_outlet_id')->whereDate('entry_at','>','2022-01-11')->get();
    // $c = 0;
    // foreach($pros as $key=>$pr){
    //     if($pr->audit_outlet_id ==0){
    //         $prod = Productarchive::find($pr->id);
    //         $prod->audit_outlet_id = $prod->outlet_id;
    //         $prod->audit_outlet_name = $prod->outlet_name;
    //         $prod->audit_at = now();
    //         //$prod->save();
    //         echo $prod->barcode.'###'.++$c.'<br/>';
    //     }
    // }
});

//User
Route::prefix('/stock')->group(function(){
    Route::get('/recalculate','api\v1\StockController@adjust_products_current_stock');
});

Route::prefix('/job')->group(function(){
    Route::get('/queue/run','api\v1\JobqueueController@run');
    Route::get('/queue/test','api\v1\JobqueueController@stock_is_zero');
    
});

Route::prefix('/reload')->group(function(){
    Route::get('/queued','api\v1\ReloadController@run_one_queued_job');
    Route::get('/clear','api\v1\ReloadController@clear');
    Route::get('/sync','api\v1\ReloadController@sync');
    Route::get('/test','api\v1\ReloadController@test');
    
});
Route::prefix('/user')->group(function(){
    Route::post('/login','api\v1\LoginController@login');
    Route::middleware('auth:api')->get('/lists','api\v1\LoginController@userList');

    Route::middleware('auth:api')->post('/assignuser','api\v1\LoginController@assigntooutlet');
});

Route::prefix('/cdn/common')->group(function(){
    //Route::middleware('cors')->get('/count/notification','api\v1\common\NotificationController@countnotif');
    Route::middleware('auth:api')->get('/count/notification-test','api\v1\common\NotificationController@countnotif');


    Route::middleware('auth:api')->get('/suppliers','api\v1\common\SupplierController@index');
    Route::middleware('auth:api')->get('/products','api\v1\common\ProductController@index');
    Route::middleware('auth:api')->get('/product/{code}','api\v1\common\ProductController@get');
    Route::middleware('auth:api')->get('/products/outletwisebarcode/{code}','api\v1\common\ProductController@outletwisebarcode');
    Route::middleware('auth:api')->get('/productfromcode/{code}','api\v1\common\ProductController@productdetailsfrombarcode');
    Route::middleware('auth:api')->get('/combinationfromcode/{code}','api\v1\common\ProductController@combinationFromCode');
   
    Route::middleware('auth:api')->get('/ecomproducts','api\v1\common\ProductController@ecomindex');
    Route::middleware('auth:api')->get('/ecomproductspaginated','api\v1\common\ProductController@paginatedProduct');
    
    Route::middleware('auth:api')->get('/colors','api\v1\common\ProductController@colors');
    

    Route::middleware('auth:api')->get('/outlets','api\v1\common\OutletController@index2');
    
    Route::middleware('auth:api')->post('/outlets','api\v1\common\OutletController@index2');
    Route::middleware('auth:api')->get('/alloutlets','api\v1\common\OutletController@all');
    Route::middleware('auth:api')->post('/alloutlets','api\v1\common\OutletController@all');
    
    Route::get('/customers/download','api\v1\common\CustomerController@allCustomer');
    
    Route::middleware('auth:api')->get('/customers','api\v1\common\CustomerController@index');
    Route::get('/importcustomer','api\v1\common\CustomerController@import');
    Route::middleware('auth:api')->get('/customerfrommobile/{mobile}','api\v1\common\CustomerController@customerfrommobile');
    Route::middleware('auth:api')->post('/createcustomer','api\v1\common\CustomerController@create');
    Route::middleware('auth:api')->post('/customer/sync','api\v1\common\CustomerController@updateCustomer');
    Route::middleware('auth:api')->get('/customer/getrange/{from}/{to}','api\v1\common\CustomerController@getCustomers');
    Route::middleware('auth:api')->get('/customer/getdetails/{id}','api\v1\common\CustomerController@getDetails');
    Route::middleware('auth:api')->get('customer/score/{cid}','api\v1\common\CustomerController@getCustomerScore');
    Route::middleware('auth:api')->get('/customer/idfrommobile/{mobile}','api\v1\common\CustomerController@idfrommobile');

    Route::middleware('auth:api')->get('/paymentmethods','api\v1\common\PaymentmethodController@index');
    Route::middleware('auth:api')->get('/barcodes/{pid}','api\v1\common\BarcodeController@getBarcodesofProduct');
    Route::middleware('auth:api')->get('/barcode/{barcode}','api\v1\common\BarcodeController@getBarcodeDetails');
    Route::middleware('auth:api')->get('/barcode/{outlet}/{barcode}/{status}','api\v1\common\BarcodeController@barcodeofoutlet');
    Route::middleware('auth:api')->post('/oldbarcode','api\v1\common\BarcodeController@getavailableOldbarcode2');

    Route::middleware('auth:api')->get('/variables/{pid}','api\v1\common\VariableproductController@getVariables');
    
    Route::middleware('auth:api')->get('/dashboard','api\v1\common\DashboardController@initdata');
    Route::middleware('auth:api')->get('/dashboard-test','api\v1\common\DashboardController@initdata');
    Route::middleware('auth:api')->get('/dashboard-range/{from}/{to}','api\v1\common\DashboardController@rangewise');

});

Route::prefix('/cdn/report')->group(function(){
    Route::middleware('auth:api')->post('/currentstock','api\v1\common\ReportController@stockReport');
    Route::middleware('auth:api')->post('/analysisreport','api\v1\common\ReportController@analysisReport');
});

Route::prefix('/management/sell')->group(function(){
    Route::middleware('auth:api')->post('/entry','api\v1\sell\SellController@init');
    Route::middleware('auth:api')->post('/invoice','api\v1\sell\SellController@getInvoiceDetails');

    Route::middleware('auth:api')->post('/return','api\v1\sell\SellController@return');
});
Route::prefix('/management/stock')->group(function(){
    Route::middleware('auth:api')->get('/reset','api\v1\StockController@reset');

    Route::middleware('auth:api')->post('/entry','api\v1\StockController@entry');
    Route::middleware('auth:api')->post('/oldentry','api\v1\StockController@oldentry');
    Route::middleware('auth:api')->post('/transfer','api\v1\StockController@transferinit');
    Route::middleware('auth:api')->post('/receive','api\v1\StockController@transferconfirm');

    Route::middleware('auth:api')->get('/prevdbentry','api\v1\StockController@preventry');

});

Route::prefix('/management/rollback')->group(function(){
    Route::middleware('auth:api')->get('/stockentry/{id}','api\v1\StockController@entryrollback');

});

Route::prefix('/statement')->group(function(){

    Route::middleware('auth:api')->post('product/return/barcode','api\v1\common\BarcodeController@getReturnBarcode');

    Route::middleware('auth:api')->get('stock_entry/details/{id}','api\v1\StockController@statementDetails');
    Route::middleware('auth:api')->get('stock_transfer/details/{id}','api\v1\StockController@transferDetails');
});

Route::prefix('/downloads')->group(function(){
    //Route::middleware('auth:api')->get('barcodes/statement/{id}','api\v1\pdf\BarcodeController@barcodes');
    Route::get('barcodes/statement/{id}','api\v1\pdf\BarcodeController@barcodes');
    Route::get('receipt/sell/invoice/threeinch/{id}','api\v1\pdf\InvoiceController@sellinvoiceThreeinch');
    Route::get('receipt/return/invoice/threeinch/{id}','api\v1\pdf\InvoiceController@sellinvoiceThreeinch');
    Route::post('sellreport','api\v1\pdf\DownloadtController@sellreport');
    Route::post('sellreport2','api\v1\pdf\DownloadtController@sellreport2');
    Route::post('returnreport','api\v1\pdf\DownloadtController@returnreport');
    Route::post('returnreport2','api\v1\pdf\DownloadtController@returnreport2');
    Route::post('bkk','api\v1\pdf\DownloadtController@testbkp');
    Route::post('finalreport','api\v1\pdf\DownloadtController@finalreport');
    Route::post('profitreport','api\v1\pdf\DownloadtController@profitreport');
});

Route::prefix('/ecommerce')->group(function(){ 
    Route::middleware('auth:api')->get('category','api\v1\ecommerce\EcommerceController@category');
    Route::middleware('auth:api')->get('product/all','api\v1\ecommerce\EcommerceController@all_products');
    Route::middleware('auth:api')->get('order/all','api\v1\ecommerce\EcommerceController@all_orders');
    Route::middleware('auth:api')->post('alldata','api\v1\ecommerce\EcommerceController@alldata');

    Route::middleware('auth:api')->post('product/create','api\v1\ecommerce\EcommerceController@submit_product');
    Route::middleware('auth:api')->post('product/delete_var','api\v1\ecommerce\EcommerceController@sync_delete_var'); 
    Route::middleware('auth:api')->post('product/softsync','api\v1\ecommerce\EcommerceController@soft_sync'); 
    
});

Route::prefix('/notification')->group(function(){
    Route::middleware('auth:api')->get('test','api\v1\notification\TestnotifController@notiftest');

});

Route::prefix('/order')->group(function(){
    Route::middleware('auth:api')->get('getorderno/{outlet}/{customer}','api\v1\order\OrderController@init');
    
    //Route::middleware('auth:api')->post('productpackaged/','api\v1\order\OrderController@productPackaged');
    Route::middleware('auth:api')->post('productshipped/','api\v1\order\OrderController@productShipped');
    Route::middleware('auth:api')->post('makepending/','api\v1\order\OrderController@makePending');
    Route::middleware('auth:api')->post('makeconfirmed','api\v1\order\OrderController@makeConfirmed');
    Route::middleware('auth:api')->post('makedelivered','api\v1\order\OrderController@makeDelivered');
    Route::middleware('auth:api')->post('makecanceled','api\v1\order\OrderController@makeCanceled');
    Route::middleware('auth:api')->post('makeexchanged','api\v1\order\OrderController@makeExchanged');

    Route::middleware('auth:api')->post('itemupdate/','api\v1\order\OrderController@itemupdate');
    Route::middleware('auth:api')->post('deleteitem/','api\v1\order\OrderController@deleteitem');
    Route::middleware('auth:api')->post('confirmtransfer/','api\v1\order\OrderController@confirmTransfer');
    Route::middleware('auth:api')->post('receivetransfer/','api\v1\order\OrderController@receiveTransfer');
    Route::middleware('auth:api')->get('receivealltransfers/{outlet}','api\v1\order\OrderController@getAllReceiveTransfers');
    

    Route::middleware('auth:api')->get('pendingtransfers/{outlet}','api\v1\order\OrderController@getPendingTransfers');
    Route::middleware('auth:api')->get('outletorders/{outlet}/{fromDate}/{toDate}','api\v1\order\OrderController@getOutletOrders');
    Route::middleware('auth:api')->get('dueBills/{outlet}/{fromDate}/{toDate}','api\v1\order\OrderController@getDueOrders');
    Route::middleware('auth:api')->get('get/{order}','api\v1\order\OrderController@getOrder');

    Route::middleware('auth:api')->get('incompleteOrders','api\v1\order\OrderController@getAllOrdersOfLastMonth');
    //public function getOrder($order){
    Route::get('print/threeinch/{order}','api\v1\order\OrderController@printThreeInchOrder'); 
    Route::get('print/a4/{order}','api\v1\order\OrderController@printA4Order'); 


});

Route::prefix('/delivery')->group(function(){
    Route::middleware('auth:api')->get('getchannel','api\v1\delivery\DeliveryController@getDeliveryChannel');
    Route::middleware('auth:api')->get('getmypackets','api\v1\delivery\DeliveryController@getMyPackets');
    Route::middleware('auth:api')->get('getmyshipments','api\v1\delivery\DeliveryController@getMyShipments');
    Route::middleware('auth:api')->post('makeshipment','api\v1\delivery\DeliveryController@makeShipment');
    Route::middleware('auth:api')->post('shipmentrequested','api\v1\delivery\DeliveryController@shipmentRequested');
    Route::middleware('auth:api')->post('shipmentcompleted','api\v1\delivery\DeliveryController@shipmentCompleted');

    Route::middleware('auth:api')->post('approve','api\v1\delivery\DeliveryController@approveHandler');
});

Route::prefix('/packaging')->group(function(){
    Route::middleware('auth:api')->post('makepackage','api\v1\packaging\PackagingController@makePacket');
    Route::middleware('auth:api')->post('discard','api\v1\packaging\PackagingController@discardPacket');
    Route::middleware('auth:api')->post('action','api\v1\packaging\PackagingController@actionHandler');
    Route::middleware('auth:api')->post('addremarks','api\v1\packaging\PackagingController@__insertRemarks');
    Route::middleware('auth:api')->post('assignboy','api\v1\packaging\PackagingController@assignBoyToPacket');
    
    //Route::middleware('auth:api')->post('updatepackage','api\v1\packaging\DeliveryController@shipmentCompleted');
});

Route::prefix('/expense')->group(function(){
    Route::middleware('auth:api')->get('query/{from}/{to}','api\v1\expense\ExpenseController@query');
    Route::middleware('auth:api')->post('/initentry','api\v1\expense\ExpenseController@initentry');
    Route::middleware('auth:api')->post('/loanentry','api\v1\expense\ExpenseController@loanentry');
    Route::middleware('auth:api')->post('/billentry','api\v1\expense\ExpenseController@billentry');
    Route::middleware('auth:api')->post('/billpay','api\v1\expense\ExpenseController@billpay');
    Route::middleware('auth:api')->post('/approve','api\v1\expense\ExpenseController@approve');

    Route::middleware('auth:api')->post('entry','api\v1\expense\ExpenseController@entry');
    
});

Route::prefix('/payroll')->group(function(){
    Route::middleware('auth:api')->get('lastpunch','api\v1\payroll\PayrollController@last_punch');
    Route::middleware('auth:api')->get('punch','api\v1\payroll\PayrollController@attendance_punch');
    Route::middleware('auth:api')->get('initdata','api\v1\payroll\PayrollController@get_init');
    Route::middleware('auth:api')->get('utility/{from}/{to}','api\v1\payroll\PayrollController@utility_fn');
    Route::middleware('auth:api')->post('generate','api\v1\payroll\PayrollController@sal_posting_calculate');
    Route::middleware('auth:api')->post('setposting','api\v1\payroll\PayrollController@setPosting');
    Route::middleware('auth:api')->post('liveattendance','api\v1\payroll\PayrollController@live_attendance');
    Route::middleware('auth:api')->post('leaveentry','api\v1\payroll\PayrollController@leaveentry');
    
    Route::get('a25bba12ec07884ba420e9d140b7283a','api\v1\payroll\PayrollController@daily_report');

    Route::get('29f2af0dba6f20335bfa1edd272fac4e/{ymon}/{eid}','api\v1\payroll\PayrollController@printSallarySheet');

});
Route::get('456bba12ec07884ba420e9d140b74322','api\v1\pdf\DownloadtController@o_entry');

Route::prefix('/balance')->group(function(){
    Route::get('456bba12ec07884ba420e9d140b74321','api\v1\balance\BalanceController@balance_cron');

    Route::middleware('auth:api')->get('/query/{from}/{to}','api\v1\balance\BalanceController@getBalances');
    Route::middleware('auth:api')->post('/transfer','api\v1\balance\BalanceController@transfer');
    Route::middleware('auth:api')->post('/withdraw','api\v1\balance\BalanceController@withdraw');
    Route::middleware('auth:api')->post('/add','api\v1\balance\BalanceController@add');
    Route::middleware('auth:api')->post('/receive','api\v1\balance\BalanceController@receive');
});

Route::prefix('/callcenter')->group(function(){
    Route::middleware('auth:api')->post('product/base/details','api\v1\callcenter\ProductController@base_details');
    Route::middleware('auth:api')->post('product/variation/details','api\v1\callcenter\ProductController@product_details');
    Route::middleware('auth:api')->post('product/allvariation/details','api\v1\callcenter\ProductController@allproduct_details');
    Route::middleware('auth:api')->post('product/base/barcodes','api\v1\callcenter\ProductController@barcodes');
});

Route::prefix('/audit')->group(function(){
    Route::middleware('auth:api')->post('barcode','api\v1\audit\AuditController@barcode_audit');
    Route::middleware('auth:api')->get('current/{outlet_id}','api\v1\audit\AuditController@current');
    Route::middleware('auth:api')->post('start-audit', 'api\v1\audit\AuditController@startAudit');
    Route::middleware('auth:api')->post('end-audit', 'api\v1\audit\AuditController@endAudit');
    Route::get('rollback', 'api\v1\audit\AuditController@audit_rollback');
});
Route::prefix('/utility')->group(function(){
    Route::middleware('auth:api')->post('barcode/makesellable','api\v1\utility\UtilityController@makesellable');
    Route::middleware('auth:api')->post('barcode/makedamage','api\v1\utility\UtilityController@makedamage');
    Route::middleware('auth:api')->post('getimage','api\v1\utility\UtilityController@getImage');
    
    
});

Route::prefix('/payment')->group(function(){
    Route::middleware('auth:api')->post('list','api\v1\payment\PaymentController@getPaymentList');
    Route::middleware('auth:api')->post('deposit','api\v1\payment\PaymentController@makePayment');
    Route::middleware('auth:api')->post('pos/deposit','api\v1\payment\PaymentController@makePosPayment');
});

Route::prefix('/test')->group(function(){
    Route::middleware('auth:api')->get('test/{statement}/{type}','api\v1\sell\SellController@profit_adjust');

});