<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePDailyReportsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('p_emp_daily_reports', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->date('r_date');
            $table->integer('outlet');
            $table->integer('emp_id');
            $table->integer('tiffin');
            $table->float('overtime'); // in minutes
            $table->integer('late');
            $table->integer('present');
            $table->time('check_in_time');
            $table->time('check_out_time');


            $table->timestamp('entry_at')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->string('entry_by');
            $table->timestamp('update_at')->default(DB::raw('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'));
            $table->string('update_by');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('p_emp_daily_reports');
    }
}
