<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePEmployeesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('p_employees', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('uid');
            $table->string('bioid');
            $table->integer('outlet');
            $table->string('name');
            $table->string('designation');
            $table->integer('salary');
            $table->integer('vacations');
            $table->integer('vacation_remains');
            $table->time('check_in_time');
            $table->time('check_out_time');


            $table->timestamp('entry_at')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->string('entry_by');
            $table->timestamp('update_at')->default(DB::raw('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'));
            $table->string('update_by');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('p_employees');
    }
}
