<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePackagingTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('packaging', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('packet_no');
            $table->string('order_no');
            $table->integer('delivery_boy_id');
            $table->string('delivery_boy_name');
            $table->integer('channel_id');
            $table->string('channel_name');
            $table->string('photo');
            $table->string('mobile');
            
            $table->json('remarks');
            $table->string('status');
            $table->string('approval_waiting');

            $table->timestamp('entry_at')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->string('entry_by');
            $table->timestamp('update_at')->default(DB::raw('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'));
            $table->string('update_by');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('packaging');
    }
}
