<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOrderTransfersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('order_transfers', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->year('fy');
            $table->date('date');
            $table->string('order_no');
            $table->string('product_code');
            $table->string('barcode_init');
            $table->string('barcode_final');
            $table->string('seller_outlet');
            $table->string('request_outlet');
            $table->integer('status');
            //$table->enum('status', ['1', '2', '3']); // 1,pending, 2 transfered, 3 confirmed
            $table->timestamp('confirmed_at');

            $table->timestamp('entry_at')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->string('entry_by');
            $table->timestamp('update_at')->default(DB::raw('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'));
            $table->string('update_by');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('order_transfers');
    }
}
