<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Order extends Model
{
    protected $table = 'orders';
    protected $casts = [
        'items'=>'array',
        'customer'=>'integer',
        'outlet'=>'integer',
        'sub_total'=>'double',
        'discount'=>'double',
        'delivery_fee'=>'double',
        'vat'=>'double',
        'net_payable'=>'double',
        'paid'=>'double',
    ];
    protected $fillable = ['order_no', 'id','pathao_consignment_id'];
    
    public $timestamps = false;
    
    public function delivery_channel()
    {
        return $this->belongsTo(DeliveryChannel::class, 'delivery_channel', 'id');
    }
    
    
    public function outlet()
    {
        return $this->belongsTo(Outlet::class, 'outlet', 'id');
    }
    public function pathao_pickup()
    {
        return $this->belongsTo(Outlet::class, 'pathao_pickup', 'id');
    }
    public function customer()
    {
        return $this->belongsTo(Customer::class, 'customer', 'id');
    }
}
