<?php

namespace App\Listeners\Utility;

use Illuminate\Contracts\Queue\ShouldQueue;
use App\Models\Product;
use App\Models\Productarchive;
use App\Models\Stock;
use Illuminate\Support\Facades\DB;

class StockGlobalRecalculate implements ShouldQueue
{   public $delay = 5;
    public $tries = 1;
    //public $timeout = 1800;
    public function handle($event)
    {
        // Reset
        DB::table('stock')->update(['quantity' => 0]);
        DB::table('products')->update(['current_stock' => 0]);
        // Stock Table
        $product_archive = Productarchive::where('status',3)->get();
        foreach ($product_archive as $product) {
            $pid = $product->product_id;
            $outlet_id = $product->outlet_id;

            DB::table('stock')
            ->where(['product' => $pid, 'outlet' => $outlet_id])
            ->increment('quantity', 1);
        }
        // Product Table Variations
        $products = Product::all();
        foreach($products as $product)
        {
            $stock = (int)Stock::where(['product'=>$product->id])->sum('quantity');
            DB::table('products')
                ->where('id',$product->id)
                ->update(['current_stock'=>$stock]);
        }
        // Product Table Base Product
        $products = Product::where('ecommerce','yes')->get();
        foreach($products as $product)
        {
            $code = $product->code;
            $stock = (int)Productarchive::where(
                [
                    ['code','like', $code.'-%'],
                    ['status','=',3]
                ]
                )->count();
            DB::table('products')
                ->where('id',$product->id)
                ->update(['current_stock'=>$stock]);
        }
    }
    
}
