<?php

namespace App\Listeners; 

use Illuminate\Contracts\Queue\ShouldQueue;
//use Illuminate\Queue\InteractsWithQueue;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Arr;

use Carbon\Carbon;

use App\Models\Order;
use App\Models\OrderTransfer;
use App\Models\Outlet;
use App\Models\Payment;
use App\Models\Productarchive;
use App\Models\OrderLog;
use App\Models\Packaging;
use App\Models\Shipment;
use App\Models\Balance_transection;
use App\Models\Balance;
use App\Models\Customer;
use App\Models\Exchange;
use App\Models\Expense;
use Codeboxr\PathaoCourier\Facade\PathaoCourier;



class PathaoHookOrderProcess
{
    public $delay = 0;
    public $tries = 5;
    
    /**
     * Create the event listener.
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     */

    public function handle(object $event): void
    {
        $r = $event->r;
        $order_no = $r['merchant_order_id'];
        $common = ['consignment_id','merchant_order_id','order_status','order_status_slug','updated_at','timestamp','store_id','payment_status','invoice_id'];
        
        if(isset($r['payment_status'])){ // All about payment
        
            $this->insertHookOrderLog($order_no,'Pathao_'.$r['payment_status'],'Pathao Payment Hook Received');
            if($r['payment_status']=='Paid'){
                $pathao = PathaoCourier::order()->orderDetails($r['consignment_id']);
                
                $parts = explode('-', $order_no);
                $arr['order_no'] = $order_no;
                
                $arr['amount'] = $pathao->total_fee;
                $arr['type'] = 1; // add first then remove
                $arr['outlet'] = (int)$parts[4];

                if($pathao->order_status=='Delivered'){ // succeessfull deliver
                    $arr['amount'] = $pathao->total_fee;
                    $arr['paymentmethod']['id'] = 1; // Cash balance
                    $arr['paymentmethod']['name'] = 'Cash';
                    // Add to cash balance
                    $arr['remarks'] = 'Automatic Expense added from Pathao Hook for Patho-Payment-ID #'.$r['invoice_id'];
                    $this->pathaoHookPayment($arr);
                    
                    // Add and remove cost from cash balance
                    // add expense
                    
                    $this->pathaoHookExpense($arr);
                    
                    // Add others to City Amex
                    $arr['amount'] = $pathao->order_amount - $pathao->total_fee;
                    $arr['type'] = 1; // add to city
                    $arr['paymentmethod']['id'] = 6; // City Amex
                    $arr['paymentmethod']['name'] = 'City Amex';
                    // Add rest to city balance
                    $this->pathaoHookPayment($arr);
                    
                    $this->pathaoHookmakeDelivered($arr);
                }
                else {
                    $arr['amount'] = $pathao->total_fee;
                    $arr['paymentmethod']['id'] = 2; // City balance
                    $arr['paymentmethod']['name'] = 'City Bank';
                    $arr['remarks'] = 'Automatic Expense added from Pathao Hook';
                    $this->pathaoHookExpense($arr);
                }
            }
        }
        else if(isset($r['order_status_slug'])){ // All about order
            $res = Arr::except($r, $common);
            $msg = $r['order_status'];
            if(count($res)>0){
                $msg = json_encode($res);
            }
            $this->insertHookOrderLog($order_no,'Pathao_Hook',$msg);
        }
        else{ // Rest Others
            $res = Arr::except($r, $common);
            if(count($res)>0){
                $msg = json_encode($res);
            }
            $this->insertHookOrderLog($order_no,'Pathao_UPDATE',$msg);
        }
        
    }
    
    private function getNewTransectionno($outlet){
        $today = date("Y-m-d");
        $test_inv = $today.'-'.$outlet;
        $statements = Balance_transection::where('transection_no','like', '%'.$test_inv.'%')->get();
        $new = $statements->count() + 1;
        return $test_inv.'-'.$new;
    }
    
    private function getNewPaymentno($outlet){
        $today = date("Y-m-d");
        $test_inv = 'P-'.$today.'-'.$outlet;
        $statements = Payment::where('payment_no','like', '%'.$test_inv.'%')->get();
        $new = $statements->count() + 1;
        return $test_inv.'-'.$new;
    }
    
    private function insertHookOrderLog($order_no,$event,$message){
        $parts = explode('-', $order_no);
        $log = new OrderLog();
        $log->order_no = $order_no;
        $log->outlet = (int)$parts[4];
        $log->event = $event;
        $log->message = $message;
        $log->entry_by = 0;
        $log->save();
    }
    
    private function pathaoHookmakeDelivered($r){
        $ret = DB::transaction(function () use ($r) {

            Order::where('order_no',$r['order_no'])
                    ->update(['status'=>'Delivered','delivered_at'=>Carbon::now()->toDateTimeString(),'update_by'=>0]);

            $pack = Packaging::where('order_no',$r['order_no'])->orderBy('entry_at','desc')->first();
            $pack->status = 'Delivered';
            $pack->approval_waiting = '';
            $pack->update_by = 0;
            $pack->save();

            $exchange =  Exchange::where('order_no','=', $r['order_no'])->where('status','=','Initiated')
            ->first();
            if($exchange === null){

            }
            else{
                $exchange->status = 'Delivered';
                $exchange->save();
                foreach ($exchange->items[0]['returned'] as $key => $value) {

                    DB::table('product_archive')
                    ->where('id',$value['barcode_id'])
                    ->update(['status'=>3,'update_by'=>0]);
                }

            }
            

            $ship = Shipment::where('order_no',$r['order_no'])->orderBy('entry_at','desc')->first();
            if($ship!=null){
                $ship->status = 'Completed';
                $ship->approval_waiting = '';
                $ship->update_by = 0;
                $ship->save();
            }

        
            $this->insertHookOrderLog($r['order_no'],'Delivered','Packet '.$pack->packet_no.' Delivered By --AUTOMATIC');
            return [
                'status'=>'success',
                'title'=>'Delivered',
                "message" => 'Order Successfully Delivered',
            ];
        });
        return $ret;
    }

    
    private function pathaoHookPayment($r){
        $ret = DB::transaction(function () use ($r) {
            $balance_amount = 0;
            $balance_method = 0;
            $type = $r['type'];
            // Cash/Partial Cash
            if($r['paymentmethod']['id']==1 || $r['paymentmethod']['id']==2){
                $balance_amount = floatval($r['amount']);
                $balance_method = 1;
                DB::table('balance')
                    ->where(['outlet' => $r['outlet'], 'balance_method' => $balance_method])
                    ->increment('amount', $balance_amount);
            }
            //City Amex, Bkash, UCB, UKash
            else if($r['paymentmethod']['id']==4 || $r['paymentmethod']['id']==6 || $r['paymentmethod']['id']==9 || $r['paymentmethod']['id']==11){
                $balance_amount = floatval($r['amount']);
                $balance_method = 2;
                DB::table('balance')
                    ->where(['outlet' => $r['outlet'], 'balance_method' => $balance_method])
                    ->increment('amount', $balance_amount);
            }
            //DBBL, Rocket, Nexus
            else if($r['paymentmethod']['id']==5 || $r['paymentmethod']['id']==7 || $r['paymentmethod']['id']==10){
                $balance_amount = floatval($r['amount']);
                $balance_method = 3;
                DB::table('balance')
                    ->where(['outlet' => $r['outlet'], 'balance_method' => $balance_method])
                    ->increment('amount', $balance_amount);
            }

            //Common Transection Log
            $transection_no = $this->getNewTransectionno($r['outlet']);    
            $transaction = new Balance_transection();
            $transaction->fy = date("Y");
            $transaction->date = date("Y-m-d");
            $transaction->transection_no = $transection_no;
            $transaction->outlet = (int)$r['outlet'];
            $transaction->amount = $balance_amount;
            $transaction->order_no = $r['order_no'];
            $transaction->balance_method = $balance_method;
            $transaction->type = $type;
            $transaction->entry_by = 0;
            $transaction->save();

            $payment_no = $this->getNewPaymentno($r['outlet']);
            $paymnt = new Payment();
            $paymnt->fy = date("Y");
            $paymnt->date = date("Y-m-d");
            $paymnt->balance_tran_no = $transection_no;
            $paymnt->payment_no = $payment_no;
            $paymnt->outlet = (int)$r['outlet'];
            $paymnt->amount = $balance_amount;
            $paymnt->order_no = $r['order_no'];
            $paymnt->balance_method = $balance_method;
            $paymnt->payment_method = (int) $r['paymentmethod']['id'];
            $paymnt->type = $type;
            $paymnt->entry_by = 0;
            $paymnt->save();

            $this->insertHookOrderLog($r['order_no'],'Payment','Payment '.$payment_no.' Amount '.$paymnt->amount.'/- Via '.$r['paymentmethod']['name'].' Entry By --AUTOMATIC');

            Order::where(['order_no' => $r['order_no']])->increment('paid', $balance_amount);
        });
        return ['ok'];

    }
    
    private function pathaoHookExpense($r){

        DB::transaction(function () use ($r) {
            //Order Info
            $order = Order::where('order_no',$r['order_no'])->first();
            $outlet = $order->outlet;
            $balance = Balance::where('outlet',$outlet)->where('balance_method',1)->first();
            
            //Expense status
            $expense = new Expense();
            $expense->expense_sector = 19; //order expense
            $expense->outlet = $outlet;
            $expense->method = 1;
            $expense->status = 'Pending';
            $expense->receipt_no = $r['order_no'];
            $expense->from_balance = $balance->id;
            $expense->amount = $r['amount'];
            $expense->remarks = 'Expense of '.$r['order_no'].' -- '.$r['remarks'];
            $expense->entry_by = 0;
            $expense->save();

            //decrement from balance
            $balance->decrement('amount',$r['amount']);
            $balance->save();
            //To frozen balance
            $to_frozen = Balance::where('outlet',$outlet)->where('balance_method',5)->first();
            $to_frozen->increment('amount',$r['amount']);
            $to_frozen->save();
        });
    }
    
}
