<?php

namespace App\Listeners\Ecommerce;

use Illuminate\Contracts\Queue\ShouldQueue;
use Automattic\WooCommerce\Client;
use App\Models\Product;
use App\Models\Productarchive;

class StockUpdateForEcommerce_bkp implements ShouldQueue
{   public $delay = 0;
    public $tries = 5;
    //public $timeout = 900;
    
    public function handle($event)
    {
        $url = env("WOOCOMMERCE_STORE_URL", env("WOOCOMMERCE_STORE_URL", "https://www.diganta.com.bd"));
        $key = env("WOOCOMMERCE_CONSUMER_KEY", env("WOOCOMMERCE_CONSUMER_KEY", "ck_5f3d7a8ecb75f6f04032e71e19d5a8e57badc4c6"));
        $secret = env("WOOCOMMERCE_CONSUMER_SECRET", env("WOOCOMMERCE_CONSUMER_SECRET", "cs_c33212654387a6a6b5c68ed64fd89c4164733e5d"));
        $version = ['wp_api' => true,'version' => 'wc/v3','verify_ssl' => false];
        $client = new Client($url,$key,$secret, $version);
        $v_code = $event->code; // Variatio Code Given
        $code = '';
        //Variation code to base code
        $arr = explode('-',$v_code);
        $l = count($arr) -2;
        for($i=0;$i<=$l;$i++){
            if($i==$l)$code.=$arr[$i];
            else $code.=$arr[$i].'-';
        }
        // Variation code is converted to base code
        $ecom_products = $client->get('products',['sku'=>$code]);
        //Make sure the product is in ecommerce
        if(isset($ecom_products[0])){
            $ecom_vars = $client->get('products/'.$ecom_products[0]->id.'/variations');
            $ecom_variations = [];
            foreach ($ecom_vars as $key => $variation) {
                if($variation->status=='publish') array_push($ecom_variations,$variation->sku);
            }
            $erp_vars = Productarchive::where('code','LIKE',$code.'-%')->where('status','=',3)->groupBy('code')->get(['code']);
            $erp_variations = [];
            foreach ($erp_vars as $key => $variation) {
                array_push($erp_variations,$variation->code);
            }

            // Make Pending of Stock Zero Variations
            $delete_variations = array_diff($ecom_variations,$erp_variations);
            if(count($delete_variations)>0){ // Some codes to be deleted
                foreach ($delete_variations as $key => $item) {
                    $var_id = 0;
                    // Get Variation ID
                    foreach ($ecom_vars as $k => $variation) {
                        if($variation->sku==$item){
                            $var_id = $variation->id;
                            break;
                        }
                    }
                    // Hide The Variation (Make Pending)
                    $client->put('products/'.$ecom_products[0]->id.'/variations/'.$var_id, ['status' => 'pending']);
                }
            }
            
            // Make Publish of New Stock Variations
            $add_variations = array_diff($erp_variations,$ecom_variations);
            if(count($add_variations)>0){ // Some codes to be added
                foreach ($add_variations as $key => $item) {
                    $var_id = 0;
                    foreach ($ecom_vars as $k => $variation) {
                        if($variation->sku==$item){
                            $var_id = $variation->id;
                            break;
                        }
                    }
                    $client->put('products/'.$ecom_products[0]->id.'/variations/'.$var_id, ['status' => 'publish']);
                }
            }
        }
        
    }
    
}
