<?php

namespace App\Listeners\Ecommerce;

use App\Models\Product;
use Illuminate\Contracts\Queue\ShouldQueue;
use Automattic\WooCommerce\Client;

class ProductUpdateForEcommerce implements ShouldQueue
{   public $delay = 0;
    public $tries = 5;
    //public $timeout = 900;
    public function handle($event)
    {
        $code = $event->code;
        $product = Product::where('code',$code)->first();
        $changes = [
            'name'=>$product->name,
            'short_description'=>$product->description,
            'description'=>$product->long_description,
        ];

        $url = config('woocommerce.store_url');
        $key = config('woocommerce.consumer_key');
        $secret = config('woocommerce.consumer_secret');
        $version = ['wp_api' => true,'version' => 'wc/v3','verify_ssl' => false];
        $client = new Client($url,$key,$secret, $version);

        // Retrive Ecommerce product
        $ecom_products = $client->get('products',['sku'=>$code]);
        if(isset($ecom_products[0])){
            $eid = $ecom_products[0]->id;

            // Check For image Changes & if then delete all images (First Commit)
            if(isset($ecom_products[0]->images[0]) && ($ecom_products[0]->images[0]->name != $product->photo)){
                $images=[];
                //$changes['images'] = null;
                $client->put('products/'.$eid, $changes);

                // Old image Delete Done.Now Prepare new image
                $temp['name'] = $product->photo;
                $temp['src'] = config('app.url').'products/images/'.$product->photo;
                array_push($images,$temp);
                $changes = [];
                $changes['images'] = $images;
            }
            // 2nd Commit
            $client->put('products/'.$eid, $changes);
        }
        
    }
}
