<?php

namespace App\Listeners\Ecommerce;

use Illuminate\Contracts\Queue\ShouldQueue;
use Automattic\WooCommerce\Client;

class ProductDeleteForEcommerce implements ShouldQueue
{   public $delay = 5;
    public $tries = 5;
    //public $timeout = 900;
    public function handle($event)
    {
        $url = config('woocommerce.store_url');
        $key = config('woocommerce.consumer_key');
        $secret = config('woocommerce.consumer_secret');
        $version = ['wp_api' => true,'version' => 'wc/v3','verify_ssl' => false];
        $client = new Client($url,$key,$secret, $version);
        $code = $event->code; // Base Code
        $ecom_products = $client->get('products',['sku'=>$code]);
        if(isset($ecom_products[0])) $client->delete('products/'.$ecom_products[0]->id, ['force' => true]);
        
    }
    
}
