<?php

namespace App\Listeners\Ecommerce;

use Illuminate\Contracts\Queue\ShouldQueue;
use Automattic\WooCommerce\Client;
use App\Models\Product;
use App\Models\Productarchive;

//class ProductAddForEcommerce
class ProductAddForEcommerce implements ShouldQueue
{   public $delay = 5;
    public $tries = 5;
    //public $timeout = 900;
    // Product Category Not handled
    public function handle($event)
    {
        $url = config('woocommerce.store_url');
        $key = config('woocommerce.consumer_key');
        $secret = config('woocommerce.consumer_secret');
        $version = ['wp_api' => true,'version' => 'wc/v3','verify_ssl' => false];
        $client = new Client($url,$key,$secret, $version);

        $code = $event->code;
        //$code = 'HF-467';
        $baseproduct = Product::where('code',$code)->first();
        $barcodes = Productarchive::where('code','LIKE',$code.'-%')->where('status','=',3)->groupBy('code')->get(['code']);
        $size_options = [];
        $variations = [];
        foreach ($barcodes as $key => $item) {
            $product = Product::where('code',$item->code)->first();
            if(!in_array($product->getsize->age_range,$size_options)){
                array_push($size_options,$product->getsize->age_range);
            }
            $v['var_data'] = [
                'sku' => $product->code,
                'regular_price' => "$product->selling_price",
                'manage_stock' => false,
                'stock_quantity' => null,
                'stock_status' => 'instock',
                'attributes'    => [
                    // [
                    //     'id'     => 1,
                    //     'option' => $product->getcolor->name,
                    // ],
                    [
                        'id'     => 2,
                        'option' => $product->getsize->age_range,
                    ],
                ],
            ];
            array_push($variations,$v);
        }
        $images=[];
        if($baseproduct->photo!=''){
            $temp = [ 'src' => config('app.window_url').'products/images/'.$baseproduct->photo];
            array_push($images,$temp);
        }
        if($baseproduct->photo1!=''){
            $temp = [ 'src' => config('app.window_url').'products/images/'.$baseproduct->photo1];
            array_push($images,$temp);
        }
        if($baseproduct->photo2!=''){
            $temp = [ 'src' => config('app.window_url').'products/images/'.$baseproduct->photo2];
            array_push($images,$temp);
        }

        $attributes = [
            // [
            //     'id' => 1,
            //     'name' => 'color',
            //     'position' => 0,
            //     'visible' => true,
            //     'variation' => true,
            //     'options' => $color_options
            // ],
            [
                'id' => 2,
                'name' => "Baby's Age",
                'position' => 1,
                'visible' => true,
                'variation' => true,
                'options' => $size_options
            ]
        ];

        $data = [
            'name' => $baseproduct->name,
            'sku' => $baseproduct->code,
            'type' => 'variable',
            'status' => 'publish',
            'price' => $baseproduct->selling_price,
            'description' => $baseproduct->long_description,
            'short_description' => $baseproduct->description,
            'categories' => $baseproduct->ecommerce_data->categories,
            "manage_stock" => false,
            "stock_quantity" =>null,
            "stock_status" => "instock",
            "attributes" => $attributes,
            'images' => $images
        ];

        $createdProduct = $client->post('products', $data);
        foreach ($variations as $key=>$var) {
            $client->post('products/'.$createdProduct->id.'/variations', $var['var_data']);
        }
        
    }
    
}
