<?php

namespace App\Listeners\Daraz;

use Illuminate\Contracts\Queue\ShouldQueue;
use shamran\easydaraz\Daraz;
use App\Models\Productarchive;

use App\Daraz\LazopSdk;
use App\Daraz\lazop\Constants;
use App\Daraz\lazop\LazopClient;
use App\Daraz\lazop\LazopRequest;

use Illuminate\Http\Request;

class StockUpdateForDaraz implements ShouldQueue
{   public $delay = 0;
    public $tries = 5;
    
    public function handle($event)
    {
        if (!defined("LAZOP_SDK_WORK_DIR"))
        {
        	define("LAZOP_SDK_WORK_DIR", dirname(__FILE__));
        }
        
        if (!defined("LAZOP_AUTOLOADER_PATH"))
        {
        	define("LAZOP_AUTOLOADER_PATH", dirname(__FILE__));
        }
        
        $url = env("DARAZ_API_APP_URL", env("DARAZ_API_APP_URL", "https://api.daraz.com.bd/rest"));
        $key = env("DARAZ_API_APP_KEY", env("DARAZ_API_APP_KEY", "500950"));
        $secret = env("DARAZ_API_APP_SECRET", env("DARAZ_API_APP_SECRET", "53RAcniLiFN8z7keDMAQuhcegtz7sHrs"));
        $code = env("DARAZ_API_APP_CODE", env("DARAZ_API_APP_CODE", "4_500950_76YcouXwf48D8RqZ7c8rCybs1745"));
        $tocken = env("DARAZ_API_APP_TOCKEN", env("DARAZ_API_APP_TOCKEN", "50000901031ptpqbgbiXjnu9rvjAEfPgpUXGGgtnvGS1fa920c2SHf0BRuvfww"));
        $refresh_tocken = env("DARAZ_API_APP_REFRESH_TOCKEN", env("DARAZ_API_APP_REFRESH_TOCKEN", "123"));
        
        $c = new LazopClient($url, $key, $secret);
        $code = $event->code;
        
        $request = new LazopRequest('/products/get','GET');
        $request->addApiParam('filter','live');
        $request->addApiParam('sku_seller_list',json_encode([$code])); //HF-582-22
        $r = json_decode($c->execute($request, $tocken));
        
        if(isset($r->data->total_products)){
            $products = $r->data->products;
            foreach ($products as $k => $p) {
                $pid = $p->item_id;
                $skus = $p->skus;
                foreach($skus as $key=>$sku){
                    if($sku->SellerSku==$code){
                        $stock = Productarchive::where('code',$sku->SellerSku)->where('status',3)->count('barcode');
                        $ssku = $sku->SellerSku;
                        $sskuid = $sku->SkuId;
                        $xml = new \SimpleXMLElement('<Request/>');
                        $product = $xml->addChild('Product');
                        $skus = $product->addChild('Skus');
                        $sku = $skus->addChild('Sku');
                        $sku->addChild('SellerSku', $ssku);
                        $sku->addChild('SkuId', $sskuid);
                        $sku->addChild('Quantity', $stock);
                        $r2 = new LazopRequest('/product/price_quantity/update');
                        $r2->addApiParam('payload',$xml->asXML()); 
                        $r2r = json_decode($c->execute($r2, $tocken));
                        sleep(2);
                    }

                    //echo $sku->SellerSku.'----:'.$stock.'<br/>';
                }
            }
        
        
            
                //             foreach ($product[$k]['Skus'] as $key => $sku) {
        //                 $stock = Productarchive::where('code',$sku['SellerSku'])->where('status',3)->count('barcode');
        //                 $update_stock_arr['Product']['Skus']['sku']['SellerSku'] = $sku['SellerSku'];
        //                 $update_stock_arr['Product']['Skus']['sku']['Quantity'] = $stock;
        //                 echo json_encode($sku['SellerSku']).'<br/>';
        //                 $daraz->updatePriceQuantity($update_stock_arr);
        //             }
            //return $r->data->products[0]->skus;
        }
        else{
            echo 'No Product Found';
        }
        
        
        
        
        
        
        

        // //Fetch SKU From Daraz
        // $arr = json_encode([$code]);
        // $result = $daraz->getProducts(null,null,null,null,null,null,null,null,null,$arr);
        // if(isset($result['response']['SuccessResponse']['Body']['TotalProducts'])){
        //     $product = $result['response']['SuccessResponse']['Body']['Products'];
        //     foreach ($product[0]['Skus'] as $key => $sku) {
        //         if($sku['SellerSku']==$code){ // Variation Found
        //             $product[0]['Skus'][$key]['quantity'] = 5;
        //             $update_stock_arr['Product']['Skus']['sku']['SellerSku'] = $sku['SellerSku'];
        //             $update_stock_arr['Product']['Skus']['sku']['Quantity'] = $stock;
        //             $daraz->updatePriceQuantity($update_stock_arr);
        //         }
        //     }
            
        // }
        // else{
        //     echo 'No Product Found';
        // }

    }
    
}
