<?php

namespace App\Http\Controllers\api\v1\utility;

use App\Http\Controllers\Controller;
use App\Models\Balance;
use App\Models\Outlet;
use App\Models\Damage;
use App\Models\Expense;
use App\Models\Productarchive;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\DB;

class UtilityController extends Controller
{
    public function getImage(Request $r){
        $data = Storage::url($r['path']);
        // $converted = mb_convert_encoding($data, 'UTF-8', 'UTF-8');
        return ['img'=>$data];
    }
    public function makedamage(Request $r){
        $dt = DB::transaction(function () use ($r) {

            $code = $r['code'];
            $barcode = Productarchive::where('barcode',$code)->where('status','!=',99)->first();
            $ret = [];
            $outlet = 1;

            if($barcode == null){
                $ret['status'] = 'error';
                $ret['title'] = 'Barcode Unavailable For Damage';
                $ret['message'] = 'Barcode Not Found';
            }
            else{
                $amount = $barcode->purchase;
                //Product Archive Updated
                $barcode->status = 99;
                $barcode->save();
                // Add To Damage List
                $damage = new Damage();
                $damage->barcode = $r['code'];
                $damage->entry_by = Auth::user()->id;
                $damage->save();
                //Expense status
                $expense = new Expense();
                $expense->expense_sector = 19; //order expense
                $expense->outlet = $outlet;
                $expense->method = 1;
                $expense->status = 'Pending';
                $expense->receipt_no = 'DAM-'.$r['code'];
                $expense->from_balance = 1;
                $expense->amount = $amount;
                $expense->remarks = 'Damage of '.$r['code'];
                $expense->entry_by = Auth::user()->id;
                $expense->save();

                //decrement from balance
                $balance = Balance::where('outlet',$outlet)->where('balance_method',1)->first();
                $balance->decrement('amount',$amount);
                $balance->save();
                //To frozen balance
                $to_frozen = Balance::where('outlet',$outlet)->where('balance_method',5)->first();
                $to_frozen->increment('amount',$amount);
                $to_frozen->save();

                $ret['status'] = 'success';
                $ret['title'] = 'Successfully Damaged';
                $ret['message'] = 'Barcode Marking As Damage Successfull.';
            }
            return $ret;
        });
        return $dt;

        
        

    }
    public function makesellable(Request $r){
        $id = $r['outlet_id'];
        $code = $r['code'];
        $barcode = Productarchive::where('barcode',$code)->first();
        $ret = [];
        if($barcode == null){
            $ret['status'] = 'error';
            $ret['title'] = 'Barcode Unavailable';
            $ret['message'] = 'Barcode Not Found';
        }
        else{
            $outlet = Outlet::find($id);
            $barcode->outlet_id = $id;
            $barcode->outlet_name = $outlet->name;
            $barcode->status = 3;
            $barcode->save();
            $ret['status'] = 'success';
            $ret['title'] = 'Successful';
            $ret['message'] = 'Barcode Reset Successfull.';
        }
        return $ret;

    }
}
