<?php

namespace App\Http\Controllers\api\v1\pdf;

use App\Http\Controllers\Controller;
use App\Models\Expense;
use App\Models\Order;
use App\Models\Outlet;
use App\Models\Payment_method;
use App\Models\Product;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

use App\Models\Sell;
use App\Models\Sell as Modelsell;
use App\Models\Product_return as Modelreturn;
use App\Models\Productarchive;
use App\Models\Production_Category;
use App\Models\SellReport;
use App\Models\Stockentry;
use PDF;

class DownloadtController extends Controller
{
    public function sellreport(Request $request){
        ini_set('memory_limit', '128M');
        ini_set('max_execution_time', '300');
        //$r = $request['data'];
        $r['outlet'] = $request['outlet'];
        $r['from'] = $request['from'];
        $r['to'] = $request['to'];
        if($request['product']=='') $r['product'] = 'All';
        else $r['product'] = $request['product'];
        $r['type'] = $request['type'];
        //return $r;
        $pdf = null;
        if($r['type']=='Complete'){
            $sells = null;
            if($r['outlet']==0){
                $sells = Modelsell::whereBetween('date', [$r['from'], $r['to']])->orderBy('outlet','asc')->get();
            }
            else{
                $sells = Modelsell::where('outlet',$r['outlet'])
                    ->whereBetween('date', [$r['from'], $r['to']])
                    ->orderBy('outlet','asc')
                    ->get();
            }
            
            $data = [ 'sells' => $sells,'type' => $r['type'],'code' => 'All','r'=>$r];
            $pdf = PDF::loadView('sellreport', $data,[],[
                'format' => 'A4',
                ]);
        }
        else if($r['type']=='Barcode'){
            $sells = null;
            $orders = null;
            if($r['outlet']==0){
                $sells = Modelsell::whereBetween('date', [$r['from'], $r['to']])->orderBy('outlet','asc')->get();
                $orders = Order::whereNotIn('status', ['Canceled','Returned','Pending','0'])->whereBetween('date', [$r['from'], $r['to']])->orderBy('outlet','asc')->get();
            }
            else{
                $sells = Modelsell::where('outlet',$r['outlet'])
                    ->whereBetween('date', [$r['from'], $r['to']])
                    ->orderBy('outlet','asc')
                    ->get();
                $orders = Order::where('outlet',$r['outlet'])->whereNotIn('status', ['Canceled','Returned','Pending','0'])->whereBetween('date', [$r['from'], $r['to']])->orderBy('outlet','asc')->get();
            }
            
            $data = [ 'sells' => $sells,'orders'=>$orders,'type' => $r['type'],'code' => $r['product'],'r'=>$r];
            $pdf = PDF::loadView('sellreport', $data,[],[
                'format' => 'A4',
                ]);
        }
        
        return $pdf->stream($r['from'].' to '.$r['to'].'-'.$r['type'].'-sell-report.pdf');
        
    }
    public function sellreport2(Request $request){
        ini_set('memory_limit', '128M');
        ini_set('max_execution_time', '300');
        //$r = $request['data'];
        $r['outlet'] = $request['outlet'];
        $r['from'] = $request['from'];
        $r['to'] = $request['to'];
        if($request['product']=='') $r['product'] = 'All';
        else $r['product'] = $request['product'];
        $r['type'] = $request['type'];
        //return $r;
        $ret = [];
        $pdf = null;
        if($r['type']=='Complete'){
            $sells = null;
            if($r['outlet']==0){
                $sells = Modelsell::whereBetween('date', [$r['from'], $r['to']])->orderBy('outlet','asc')->get();
            }
            else{
                $sells = Modelsell::where('outlet',$r['outlet'])
                    ->whereBetween('date', [$r['from'], $r['to']])
                    ->orderBy('outlet','asc')
                    ->get();
            }
            
            $data = [ 'sells' => $sells,'type' => $r['type'],'code' => 'All','r'=>$r];
            $pdf = PDF::loadView('sellreport', $data,[],[
                'format' => 'A4',
                ]);
        }
        else if($r['type']=='Barcode'){
            $sells = null;
            $orders = null;
            if($r['outlet']==0){
                $sells = Modelsell::whereBetween('date', [$r['from'], $r['to']])->orderBy('outlet','asc')->get();
                $orders = Order::whereNotIn('status', ['Canceled','Returned','Pending','0'])->whereBetween('date', [$r['from'], $r['to']])->orderBy('outlet','asc')->get();
            }
            else{
                $sells = Modelsell::where('outlet',$r['outlet'])
                    ->whereBetween('date', [$r['from'], $r['to']])
                    ->orderBy('outlet','asc')
                    ->get()->toArray();
                $orders = Order::where('outlet',$r['outlet'])->whereNotIn('status', ['Canceled','Returned','Pending','0'])->whereBetween('date', [$r['from'], $r['to']])
                ->orderBy('outlet','asc')->get()->toArray();
            }
            $s_codes = [];
            $o_codes = [];
            foreach($sells as $sel){
                foreach($sel['items'] as $itm){
                    array_push($s_codes,$itm['barcode']);
                }
            }
            
            foreach($orders as $ordr){
                foreach($ordr['items'] as $itm)
                {
                    array_push($o_codes,$itm['barcode']);
                }
            }
            
            $data = [ 'sells' => $s_codes,'orders'=>$o_codes];
            $ret = $data;
            // $pdf = PDF::loadView('sellreport', $data,[],[
            //     'format' => 'A4',
            //     ]);
        }
        return $ret;
        //return $pdf->stream($r['from'].' to '.$r['to'].'-'.$r['type'].'-sell-report.pdf');
        
    }
    
    
    public function returnreport(Request $request){
        ini_set('memory_limit', '128M');
        //$r = $request['data'];
        $r['outlet'] = $request['outlet'];
        $r['from'] = $request['from'];
        $r['to'] = $request['to'];
        if($request['product']=='') $r['product'] = 'All';
        else $r['product'] = $request['product'];
        $r['type'] = $request['type'];
        //return $r;
        $pdf = null;
        if($r['type']=='Complete'){
            if($r['outlet']==0){
                $sells = Modelreturn::whereBetween('date', [$r['from'], $r['to']])->get();
            }
            else{
                $sells = Modelreturn::where('outlet',$r['outlet'])
                    ->whereBetween('date', [$r['from'], $r['to']])
                    ->get();
            }
            
            $data = [ 'returns' => $sells,'type' => $r['type'],'code' => 'All','r'=>$r];
            $pdf = PDF::loadView('returnreport', $data,[],[
                'format' => 'A4',
                ]);
        }
        else if($r['type']=='Barcode'){
            if($r['outlet']==0){
                $sells = Modelreturn::whereBetween('date', [$r['from'], $r['to']])->get();
            }
            else{
                $sells = Modelreturn::where('outlet',$r['outlet'])
                    ->whereBetween('date', [$r['from'], $r['to']])
                    ->get();
            }
            
            $data = [ 'returns' => $sells,'type' => $r['type'],'code' => $r['product'],'r'=>$r];
            $pdf = PDF::loadView('returnreport', $data,[],[
                'format' => 'A4',
                ]);
        }
        
        return $pdf->stream($r['from'].' to '.$r['to'].'-'.$r['type'].'-return-report.pdf');
        
    }
    public function testbkp(){
        Productarchive::where('status',3)->where('audit_outlet_id',0)->update(['status' => 404]);
        return Productarchive::select('id', 'barcode', 'outlet_id', 'outlet_name')->where('status',3)->where('audit_outlet_id',0)->orderBy('outlet_id','asc')->get()->toArray();
    }
    public function returnreport2(Request $request){
        ini_set('memory_limit', '128M');
        //$r = $request['data'];
        $r['outlet'] = $request['outlet'];
        $r['from'] = $request['from'];
        $r['to'] = $request['to'];
        if($request['product']=='') $r['product'] = 'All';
        else $r['product'] = $request['product'];
        $r['type'] = $request['type'];
        //return $r;
        $ret = [];
        $pdf = null;
        if($r['type']=='Complete'){
            if($r['outlet']==0){
                $sells = Modelreturn::whereBetween('date', [$r['from'], $r['to']])->get();
            }
            else{
                $sells = Modelreturn::where('outlet',$r['outlet'])
                    ->whereBetween('date', [$r['from'], $r['to']])
                    ->get();
            }
            
            $data = [ 'returns' => $sells,'type' => $r['type'],'code' => 'All','r'=>$r];
            $pdf = PDF::loadView('returnreport', $data,[],[
                'format' => 'A4',
                ]);
        }
        else if($r['type']=='Barcode'){
            if($r['outlet']==0){
                $sells = Modelreturn::whereBetween('date', [$r['from'], $r['to']])->get();
            }
            else{
                $sells = Modelreturn::where('outlet',$r['outlet'])
                    ->whereBetween('date', [$r['from'], $r['to']])
                    ->get();
            }
            
                    $rs_codes = [];
                    $ro_codes = [];
                    foreach($sells as $sel){
                        foreach($sel['items'] as $itm){
                            array_push($rs_codes,$itm['barcode']);
                        }
                    }
                    
                    
                    $data = [ 'return' => $rs_codes];
                    $ret = $data;
            
            // $data = [ 'returns' => $sells,'type' => $r['type'],'code' => $r['product'],'r'=>$r];
            // $pdf = PDF::loadView('returnreport', $data,[],[
            //     'format' => 'A4',
            //     ]);
        }
        //return $pdf->stream($r['from'].' to '.$r['to'].'-'.$r['type'].'-return-report.pdf');
        return $ret;
        
    }
    public function o_entry(){
        $begin = new \DateTime(date("Y-m-d",strtotime("-1 days")));
        $end = new \DateTime(date("Y-m-d"));
        // $begin = new \DateTime('2020-09-14');
        // $end = new \DateTime(date("Y-m-d"));

        $daterange = new \DatePeriod($begin, new \DateInterval('P1D'), $end);
        
        $o_status = ['Confirmed','Packaged','Shipped','Delivered','Completed'];
        $outlets = Outlet::all();
        foreach($daterange as $date){
            foreach ($outlets as $k => $outlet) {
                $sell_codes = [];
                $sell_barcodes = [];
                $pos = Modelsell::where('outlet',$outlet->id)->where('date',$date->format("Y-m-d"))->get();
                foreach ($pos as $key => $s) {
                    foreach ($s->items as $key => $item) {
                        if(!array_search($item['code'],$sell_codes)){
                            array_push($sell_codes,$item['code']); 
                        }
                        if(!array_search($item['barcode'],$sell_barcodes)){
                            array_push($sell_barcodes,$item['barcode']); 
                        }
                    }
                    //echo $date->format("Y-m-d") .$s->invoice_no ."<br>";
                } 
                $order = Order::where('outlet',$outlet->id)->where('date',$date->format("Y-m-d"))
                        ->whereIn('status', $o_status)->get();
                foreach ($order as $key => $s) {
                    if($s->items){
                        foreach ($s->items as $key => $item) {
                            if(!array_search($item['code'],$sell_codes)){
                                array_push($sell_codes,$item['code']); 
                            }
                            if(!array_search($item['barcode'],$sell_barcodes)){
                                array_push($sell_barcodes,$item['barcode']); 
                            }
                        }
                    }
                }
                if(count($sell_codes)>0 || count($sell_barcodes)>0){
                    sort($sell_codes);
                    sort($sell_barcodes);
                    $sellReport = new SellReport();
                    $sellReport->date = $date->format("Y-m-d");
                    $sellReport->outlet = $outlet->id;
                    $sellReport->sell_codes = $sell_codes;
                    $sellReport->sell_barcodes = $sell_barcodes;
                    $sellReport->save();
                }
                
            }
            
            
        }
        
        //return $sell_barcodes;
        // Make Complete of old orders
        $onemonth = new \DateTime(date("Y-m-d",strtotime("-30 days")));
        DB::table('orders')
                    ->where('date','<=',$onemonth)->where('status','=','Delivered')
                    ->update(['status'=>'Completed']);
    }
    public function profitreport(Request $request){
        ini_set('memory_limit', '128M');
        //if(Auth::user()->id==1 || Auth::user())
        $r['from'] = $request['from'];
        $r['to'] = $request['to'];
        $r['outlet'] = $request['outlet'];
        $ret['production_profit'] = 0;
        $ret['total_purchase'] = 0;
        $o = Outlet::where('id',$r['outlet'])->first();
        $r['outlet_name'] = $o->name;
        if($r['outlet']==0){
            $rt = DB::table('sell')
            ->select(DB::raw('SUM(price_total) as total, SUM(vat) as vat, SUM(discount) as discount'))
            ->whereBetween('date', [$r['from'], $r['to']])
            ->get();
            $ret['pos_sell'] = (float)$rt[0]->total;
            $ret['pos_discount'] = (float)$rt[0]->discount; 
            $ret['pos_vat'] = (float)$rt[0]->vat;

            $rt = DB::table('product_returns')
                        ->select(DB::raw('SUM(amount) as ret_total'))
                        ->whereBetween('date', [$r['from'], $r['to']])
                        ->get();
            $ret['pos_return'] = (float)$rt[0]->ret_total;

            // Order based Sell
            $o_status = ['Confirmed','Packaged','Shipped','Delivered','Completed'];
            $rt = null;
            $rt = DB::table('orders')
            ->select(DB::raw('SUM(sub_total) as subtotal,  SUM(discount) as discount, SUM(delivery_fee) as deliveryfee, SUM(vat) as vat'))
            ->whereBetween('date', [$r['from'], $r['to']])
            ->whereIn('status', $o_status)
            ->get();
            $ret['order_sell'] = (float)$rt[0]->subtotal;
            $ret['order_discount'] = (float)$rt[0]->discount;
            $ret['order_deliveryfee'] = (float)$rt[0]->deliveryfee; 
            $ret['order_vat'] = (float)$rt[0]->vat;

            $ret['sell'] = $ret['pos_sell'] + $ret['order_sell'];
            $ret['return'] = $ret['pos_return'] + 0;
            $ret['discount'] = $ret['pos_discount'] + $ret['order_discount'];
            $ret['vat'] = $ret['pos_vat'] + $ret['order_vat'];
            $ret['deliveryfee'] = $ret['order_deliveryfee'];
            $ret['total_revenue'] = $ret['sell'] - $ret['discount'] - $ret['return'] + $ret['vat'] + $ret['deliveryfee'];
            $ret['total_expense'] = 0;


            $rt = Expense::
            select(DB::raw('expense_sector, SUM(amount) as total'))
            ->whereBetween('entry_at', [$r['from'], $r['to']])
            ->where('status', 'Approved')
            ->with([
                'sector'=> function($query) {
                    $query->select('id','name');
                }
            ])
            ->groupBy('expense_sector')
            ->orderBy('expense_sector','asc')
            ->get();
            if($rt){
                $ret['expenses'] = $rt;
                foreach ($rt as $k => $exp) {
                    $ret['total_expense']+= $exp->total;
                }
            }
            else{
                $ret['expenses'] = [];
            }
        }
        else{
            $rt = DB::table('sell')
            ->select(DB::raw('SUM(price_total) as total, SUM(vat) as vat, SUM(discount) as discount'))
            ->whereBetween('date', [$r['from'], $r['to']])
            ->where('outlet',$r['outlet'])
            ->get();

            $ret['pos_sell'] = (float)$rt[0]->total;
            $ret['pos_discount'] = (float)$rt[0]->discount; 
            $ret['pos_vat'] = (float)$rt[0]->vat; 

            $rt = DB::table('product_returns')
                        ->select(DB::raw('SUM(amount) as ret_total'))
                        ->whereBetween('date', [$r['from'], $r['to']])
                        ->where('outlet',$r['outlet'])
                        ->get();
            $ret['pos_return'] = (float)$rt[0]->ret_total;
            //Head Office Production Profit
            $ret['production_profit'] = 0;
            if($r['outlet']==1){
                
                $entries = Stockentry::select(DB::raw('items'))
                ->whereBetween('entry_at', [$r['from'], $r['to']])
                ->get();
                foreach ($entries as $key => $item) {
                    foreach ($item->items as $key => $itm) {
                        if(isset($itm['prod_cat'])){
                            $prodid = $itm['prod_cat']['id'];
                            $prod = Production_Category::where('id',$prodid)->first();
                            $profit = $prod->profit;
                            $ret['production_profit']+= ($profit*((int)$itm['qtt']));
                        }
                        
                    }
                    
                }
            }
            
            //Purchase Price
            //Sell Purchase
            $barcodes = Sell::select(DB::raw('items'))
            ->whereBetween('date', [$r['from'], $r['to']])
            ->where('outlet',$r['outlet'])
            ->get();
            $ret['pos_purchase'] = 0;
            foreach ($barcodes as $key => $item) {
                foreach ($item->items as $key => $itm) {
                    //var_dump($item);
                    if(isset($itm['purchase_price'])) $ret['pos_purchase'] += $itm['purchase_price'];
                    else $ret['pos_purchase'] += $itm['price']*.55;
                }
            }
            // Order Purchase
            $o_status = ['Confirmed','Packaged','Shipped','Delivered','Completed'];
            $barcodes = Order::select(DB::raw('items'))
            ->whereBetween('date', [$r['from'], $r['to']])
            ->where('outlet',$r['outlet'])
            ->whereIn('status', $o_status)
            ->get();
            
            $ret['order_purchase'] = 0;
            foreach ($barcodes as $key => $item) {
                foreach ($item->items as $key => $itm) {
                    $barcode = Productarchive::where('barcode',$itm['barcode'])->first();
                    $ret['order_purchase'] += $barcode->purchase;
                }
                
            }
            $ret['total_purchase'] = $ret['pos_purchase'] + $ret['order_purchase'];
            // Order based Sell
            
            $rt = null;
            $rt = DB::table('orders')
            ->select(DB::raw('SUM(sub_total) as subtotal,  SUM(discount) as discount, SUM(delivery_fee) as deliveryfee, SUM(vat) as vat'))
            ->whereBetween('date', [$r['from'], $r['to']])
            ->where('outlet',$r['outlet'])
            ->whereIn('status', $o_status)
            ->get();
            $ret['order_sell'] = (float)$rt[0]->subtotal;
            $ret['order_discount'] = (float)$rt[0]->discount;
            $ret['order_deliveryfee'] = (float)$rt[0]->deliveryfee; 
            $ret['order_vat'] = (float)$rt[0]->vat;

            $ret['sell'] = $ret['pos_sell'] + $ret['order_sell'];
            $ret['return'] = $ret['pos_return'] + 0;
            $ret['discount'] = $ret['pos_discount'] + $ret['order_discount'];
            $ret['vat'] = $ret['pos_vat'] + $ret['order_vat'];
            $ret['deliveryfee'] = $ret['order_deliveryfee'];
            $ret['total_revenue'] = $ret['sell'] - $ret['discount'] - $ret['return'] + $ret['vat'] + $ret['deliveryfee'];
            $ret['total_expense'] = 0;

            $rt = Expense::
            select(DB::raw('expense_sector, SUM(amount) as total'))
            ->whereBetween('entry_at', [$r['from'], $r['to']])
            ->where('status', 'Approved')
            ->where('outlet',$r['outlet'])
            ->with([
                'sector'=> function($query) {
                    $query->select('id','name');
                }
            ])
            ->groupBy('expense_sector')
            ->orderBy('expense_sector','asc')
            ->get();
            if($rt){
                $ret['expenses'] = $rt;
                foreach ($rt as $k => $exp) {
                    $ret['total_expense']+= $exp->total;
                }
            }
            else{
                $ret['expenses'] = [];
            }
        }
        
        $data = [ 'data' => $ret,'type' => 'Profit','code' => 'All','r'=>$r];
        $pdf = PDF::loadView('profitreport', $data,[],[
                'format' => 'A4',
                ]);
        
        return $pdf->stream($r['from'].' to '.$r['to'].'-Profit-report.pdf');
        return $ret;
    }
    public function finalreport(Request $request){
        ini_set('memory_limit', '128M');
        //$code = 'PG-1314-28-34'; // COUNT(id) as no_of_pos_sell, json_extract('items', '$.code')
        // $from = '2021-01-01';
        // $to = '2021-09-01';
        // $products = Product::select('code')->get();
        // $ret = [];
        // foreach ($products as $key => $prod) {
        //     $code = $prod->code;
        //     $r[$code] = Modelsell::select(DB::raw('date,count(id) as qtt'))
        //     ->whereBetween('date', [$from, $to])
        //     ->whereJsonContains('items',['code'=>$code])->groupBy('date')->get();
        //     array_push($ret,$r);
        // }
    
        // return $ret;
        //print_r($d);
        //$r = $request['data'];
        $r['outlet'] = $request['outlet'];
        $r['from'] = $request['from'];
        $r['to'] = $request['to'];
        if($request['product']=='') $r['product'] = 'All';
        else $r['product'] = $request['product'];
        $r['type'] = $request['type'];
        //return $r;
        
        $this->calculatePriceTotal();
        
        $pdf = null;
        $rt = null;
        if($r['outlet']==0){
            $rt = DB::table('sell')
            ->select(DB::raw('SUM(price_total) as total, SUM(vat) as vat, SUM(discount) as discount, SUM(payable) as net,SUM(paid) as paid, SUM(paid2) as paid2, SUM(paid3) as paid3,  COUNT(id) as qtt, SUM(JSON_LENGTH(items)) as barcodes'))
            ->whereBetween('date', [$r['from'], $r['to']])
            ->get();
        }
        else{
            $rt = DB::table('sell')
            ->select(DB::raw('SUM(price_total) as total,SUM(vat) as vat, SUM(discount) as discount, SUM(payable) as net, SUM(paid) as paid, SUM(paid2) as paid2, SUM(paid3) as paid3,  COUNT(id) as qtt, SUM(JSON_LENGTH(items)) as barcodes'))
            ->where('outlet',$r['outlet'])
            ->whereBetween('date', [$r['from'], $r['to']])
            ->get();
        }

        $ret['sell'] = $rt[0]->total;
        $ret['discount'] = $rt[0]->discount; 
        $ret['qtt'] = $rt[0]->qtt; 
        $ret['vat'] = $rt[0]->vat; 
        $ret['barcodes'] = $rt[0]->barcodes; 
        $ret['net'] = $rt[0]->total - $rt[0]->discount + $ret['vat'];
        $ret['paid'] = $rt[0]->paid + $rt[0]->paid2 + $rt[0]->paid3;
        //$ret['due'] = $rt[0]->net - ($rt[0]->paid + $rt[0]->paid2 + $rt[0]->paid3);

        // Order based Sell
        //'0','Pending','Confirmed','Packaged','Shipped','Delivered','Completed','Canceled'
        $o_status = ['Confirmed','Packaged','Shipped','Delivered','Completed','Canceled'];
        // all order except cancel
        $rt = null;
        if($r['outlet']==0){
            $rt = DB::table('orders')
            ->select(DB::raw('SUM(sub_total) as subtotal, SUM(net_payable) as revenue, SUM(paid) as paid, SUM(discount) as discount, SUM(delivery_fee) as deliveryfee, SUM(vat) as vat,  COUNT(id) as qtt, SUM(JSON_LENGTH(items)) as barcodes'))
            ->whereBetween('date', [$r['from'], $r['to']])
            ->whereIn('status', $o_status)
            ->get();
        }
        else{
            $rt = DB::table('orders')
            ->select(DB::raw('SUM(sub_total) as subtotal, SUM(net_payable) as revenue, SUM(paid) as paid, SUM(discount) as discount, SUM(delivery_fee) as deliveryfee, SUM(vat) as vat,  COUNT(id) as qtt, SUM(JSON_LENGTH(items)) as barcodes'))
            ->where('outlet',$r['outlet'])
            ->whereBetween('date', [$r['from'], $r['to']])
            ->whereIn('status', $o_status)
            ->get();
        }

        $ret['order_revenue'] = $rt[0]->revenue;
        $ret['order_subtotal'] = $rt[0]->subtotal;
        $ret['order_paid'] = $rt[0]->paid; 
        $ret['order_discount'] = $rt[0]->discount;
        $ret['order_deliveryfee'] = $rt[0]->deliveryfee; 
        $ret['order_vat'] = $rt[0]->vat; 
        $ret['order_barcodes'] = $rt[0]->barcodes; 
        $ret['order_qtt'] = $rt[0]->qtt;
        
        // Canceled Orders
        $rt = null;
        if($r['outlet']==0){
            $rt = DB::table('orders')
            ->join('order_log', 'orders.order_no', '=', 'order_log.order_no')
            ->where('order_log.event', 'Canceled')
            ->whereBetween('order_log.date', [$r['from'], $r['to']])
            ->where('orders.status', 'Canceled')
            ->select(DB::raw('SUM(orders.sub_total) as subtotal, SUM(orders.net_payable) as revenue, SUM(orders.paid) as paid, SUM(orders.discount) as discount, SUM(orders.delivery_fee) as deliveryfee, SUM(orders.vat) as vat,  COUNT(orders.id) as qtt, SUM(JSON_LENGTH(orders.items)) as barcodes'))
            //->whereBetween('date', [$r['from'], $r['to']])
            //->where('status', 'Canceled')
            ->get();
        }
        else{
            // $rt = DB::table('orders')
            // ->select(DB::raw('SUM(sub_total) as subtotal, SUM(net_payable) as revenue, SUM(paid) as paid, SUM(discount) as discount, SUM(delivery_fee) as deliveryfee, SUM(vat) as vat,  COUNT(id) as qtt, SUM(JSON_LENGTH(items)) as barcodes'))
            // ->where('outlet',$r['outlet'])
            // ->whereBetween('date', [$r['from'], $r['to']])
            // ->whereIn('status', 'Canceled')
            // ->get();
            
            $rt = DB::table('orders')
            ->join('order_log', 'orders.order_no', '=', 'order_log.order_no')
            ->where('order_log.event', 'Canceled')
            ->whereBetween('order_log.date', [$r['from'], $r['to']])
            ->where('orders.status', 'Canceled')
            ->where('orders.outlet',$r['outlet'])
            ->select(DB::raw('SUM(orders.sub_total) as subtotal, SUM(orders.net_payable) as revenue, SUM(orders.paid) as paid, SUM(orders.discount) as discount, SUM(orders.delivery_fee) as deliveryfee, SUM(orders.vat) as vat,  COUNT(orders.id) as qtt, SUM(JSON_LENGTH(orders.items)) as barcodes'))
            //->whereBetween('date', [$r['from'], $r['to']])
            //->where('status', 'Canceled')
            ->get();
        }

        $ret['canceled_revenue'] = $rt[0]->revenue;
        $ret['canceled_subtotal'] = $rt[0]->subtotal;
        $ret['canceled_paid'] = $rt[0]->paid; 
        $ret['canceled_discount'] = $rt[0]->discount;
        $ret['canceled_deliveryfee'] = $rt[0]->deliveryfee; 
        $ret['canceled_vat'] = $rt[0]->vat; 
        $ret['canceled_barcodes'] = $rt[0]->barcodes; 
        $ret['canceled_qtt'] = $rt[0]->qtt;

        //Discount
        $rt = null;
        if($r['outlet']==0){
            $rt = DB::table('sell')
                        ->select(DB::raw('COUNT(id) as dis_qtt'))
                        ->where('discount','>',0)
                        ->whereBetween('date', [$r['from'], $r['to']])
                        ->get();
        }
        else{
            $rt = DB::table('sell')
                        ->select(DB::raw('COUNT(id) as dis_qtt'))
                        ->where('discount','>',0)
                        ->where('outlet',$r['outlet'])
                        ->whereBetween('date', [$r['from'], $r['to']])
                        ->get();
        }
        
        $ret['dis_qtt'] = $rt[0]->dis_qtt;

        // Vat
        //Discount
        $rt = null;
        if($r['outlet']==0){
            $rt = DB::table('sell')
                        ->select(DB::raw('COUNT(id) as vat_qtt'))
                        ->where('vat','>',0)
                        ->whereBetween('date', [$r['from'], $r['to']])
                        ->get();
        }
        else{
            $rt = DB::table('sell')
                        ->select(DB::raw('COUNT(id) as vat_qtt'))
                        ->where('vat','>',0)
                        ->where('outlet',$r['outlet'])
                        ->whereBetween('date', [$r['from'], $r['to']])
                        ->get();
        }
        
        $ret['vat_qtt'] = $rt[0]->vat_qtt;

        //Return
        $rt = null;
        if($r['outlet']==0){
            $rt = DB::table('product_returns')
                        ->select(DB::raw('SUM(amount) as ret_total, COUNT(id) as ret_qtt, SUM(JSON_LENGTH(items)) as ret_barcodes'))
                        ->whereBetween('date', [$r['from'], $r['to']])
                        ->get();
        }
        else{
            $rt = DB::table('product_returns')
                        ->select(DB::raw('SUM(amount) as ret_total, COUNT(id) as ret_qtt, SUM(JSON_LENGTH(items)) as ret_barcodes'))
                        ->where('outlet',$r['outlet'])
                        ->whereBetween('date', [$r['from'], $r['to']])
                        ->get();
        }
        
        $ret['ret_total'] = $rt[0]->ret_total;
        $ret['ret_qtt'] = $rt[0]->ret_qtt;
        $ret['ret_barcodes'] = $rt[0]->ret_barcodes;
        
        /// End of Net Revenue
        // Order Balance/Payments
        for($b_method=1;$b_method<=3;$b_method++){
            if($r['outlet']==0){
                //Balance IN
                $rt = DB::table('payments')
                    ->select(DB::raw('SUM(amount) as amount'))
                    ->where('balance_method',$b_method)
                    ->where('amount','>',0)
                    ->whereBetween('date', [$r['from'], $r['to']])
                    ->get();
                $ret['order_balance'][$b_method]['in'] = $rt[0]->amount;

                //BALANCE OUT

                $rt = DB::table('payments')
                    ->select(DB::raw('SUM(amount) as amount'))
                    ->where('balance_method',$b_method)
                    ->where('amount','<',0)
                    ->whereBetween('date', [$r['from'], $r['to']])
                    ->get();
                $ret['order_balance'][$b_method]['out'] = $rt[0]->amount;
            }
            else{
                //Balance IN
                $rt = DB::table('payments')
                ->select(DB::raw('SUM(amount) as amount'))
                ->where('balance_method',$b_method)
                ->where('outlet',$r['outlet'])
                ->where('amount','>',0)
                ->whereBetween('date', [$r['from'], $r['to']])
                ->get();
                $ret['order_balance'][$b_method]['in'] = $rt[0]->amount;

                //BALANCE OUT

                $rt = DB::table('payments')
                ->select(DB::raw('SUM(amount) as amount'))
                ->where('balance_method',$b_method)
                ->where('outlet',$r['outlet'])
                ->where('amount','<',0)
                ->whereBetween('date', [$r['from'], $r['to']])
                ->get();
                $ret['order_balance'][$b_method]['out'] = $rt[0]->amount;
            }
            

        }
        // Card Payments
        $p_methods = Payment_method::where('credit_card',1)->get();
        foreach ($p_methods as $key => $method) {
            $mid = $method->id;
            if($r['outlet']==0){
                $rt = DB::table('payments')
                ->select(DB::raw('SUM(amount) as amount'))
                ->where('payment_method',$mid)
                ->whereBetween('date', [$r['from'], $r['to']])
                ->get();
                $ret['order_card_payments'][$key] = $rt[0]->amount;
            }
            else{
                $rt = DB::table('payments')
                ->select(DB::raw('SUM(amount) as amount'))
                ->where('payment_method',$mid)
                ->where('outlet',$r['outlet'])
                ->whereBetween('date', [$r['from'], $r['to']])
                ->get();
                $ret['order_card_payments'][$key] = $rt[0]->amount;
            }

        }
        //POS Balances
        $rt = null;
        if($r['outlet']==0){
            $rt = DB::table('balance_transections')
                        ->select(DB::raw('SUM(amount) as cash_sell'))
                        ->where('balance_method',1)
                        ->whereNull('order_no')
                        ->where('type',1)
                        ->whereBetween('date', [$r['from'], $r['to']])
                        ->get();
        }
        else{
            $rt = DB::table('balance_transections')
                        ->select(DB::raw('SUM(amount) as cash_sell'))
                        ->where('outlet',$r['outlet'])
                        ->where('balance_method',1)
                        ->whereNull('order_no')
                        ->where('type',1)
                        ->whereBetween('date', [$r['from'], $r['to']])
                        ->get();
        }
        
        $ret['cash_sell'] = $rt[0]->cash_sell;

        $rt = null;
        if($r['outlet']==0){
            $rt = DB::table('balance_transections')
                        ->select(DB::raw('SUM(amount) as cash_return'))
                        ->where('balance_method',1)
                        ->whereNull('order_no')
                        ->where('type',-1)
                        ->whereBetween('date', [$r['from'], $r['to']])
                        ->get();
        }
        else{
            $rt = DB::table('balance_transections')
                        ->select(DB::raw('SUM(amount) as cash_return'))
                        ->where('outlet',$r['outlet'])
                        ->where('balance_method',1)
                        ->whereNull('order_no')
                        ->where('type',-1)
                        ->whereBetween('date', [$r['from'], $r['to']])
                        ->get();
        }
        
        $ret['cash_return'] = $rt[0]->cash_return;
        
        $rt = null;
        if($r['outlet']==0){
            $rt = DB::table('balance_transections')
                        ->select(DB::raw('SUM(amount) as city_sell'))
                        ->where('balance_method',2)
                        ->whereNull('order_no')
                        ->where('type',1)
                        ->whereBetween('date', [$r['from'], $r['to']])
                        ->get();
        }
        else{
            $rt = DB::table('balance_transections')
                        ->select(DB::raw('SUM(amount) as city_sell'))
                        ->where('outlet',$r['outlet'])
                        ->where('balance_method',2)
                        ->whereNull('order_no')
                        ->where('type',1)
                        ->whereBetween('date', [$r['from'], $r['to']])
                        ->get();
        }
        
        $ret['city_sell'] = $rt[0]->city_sell;
        
        $rt = null;
        if($r['outlet']==0){
            $rt = DB::table('balance_transections')
                        ->select(DB::raw('SUM(amount) as city_return'))
                        ->where('balance_method',2)
                        ->whereNull('order_no')
                        ->where('type',-1)
                        ->whereBetween('date', [$r['from'], $r['to']])
                        ->get();
        }
        else{
            $rt = DB::table('balance_transections')
                        ->select(DB::raw('SUM(amount) as city_return'))
                        ->where('outlet',$r['outlet'])
                        ->where('balance_method',2)
                        ->whereNull('order_no')
                        ->where('type',-1)
                        ->whereBetween('date', [$r['from'], $r['to']])
                        ->get();
        }
        
        $ret['city_return'] = $rt[0]->city_return;
        $rt = null;
        if($r['outlet']==0){
            $rt = DB::table('balance_transections')
                        ->select(DB::raw('SUM(amount) as dbbl_sell'))
                        ->where('balance_method',3)
                        ->whereNull('order_no')
                        ->where('type',1)
                        ->whereBetween('date', [$r['from'], $r['to']])
                        ->get();
        }
        else{
            $rt = DB::table('balance_transections')
                        ->select(DB::raw('SUM(amount) as dbbl_sell'))
                        ->where('outlet',$r['outlet'])
                        ->where('balance_method',3)
                        ->whereNull('order_no')
                        ->where('type',1)
                        ->whereBetween('date', [$r['from'], $r['to']])
                        ->get();
        }
        $ret['dbbl_sell'] = $rt[0]->dbbl_sell;
        
        $rt = null;
        if($r['outlet']==0){
            $rt = DB::table('balance_transections')
                        ->select(DB::raw('SUM(amount) as dbbl_return'))
                        ->where('balance_method',3)
                        ->whereNull('order_no')
                        ->where('type',-1)
                        ->whereBetween('date', [$r['from'], $r['to']])
                        ->get();
        }
        else{
            $rt = DB::table('balance_transections')
                        ->select(DB::raw('SUM(amount) as dbbl_return'))
                        ->where('outlet',$r['outlet'])
                        ->whereNull('order_no')
                        ->where('balance_method',3)
                        ->where('type',-1)
                        ->whereBetween('date', [$r['from'], $r['to']])
                        ->get();
        }
        
        $ret['dbbl_return'] = $rt[0]->dbbl_return;
        
        
        //// Payment method wise collection
        $ret['Bkash'] = 0.0;
        $ret['Rocket'] = 0.0;
        $ret['City Amex'] = 0.0;
        $ret['DBBL'] = 0.0;
        $ret['UCB'] = 0.0;
        $ret['Nexus'] = 0.0;
        $ret['UKash'] = 0.0;
        $ret['Nagad'] = 0.0;
        $sells = null;
        if($r['outlet']==0){
            $sells = DB::table('sell')->where('payment_method','>',1)
                        ->whereBetween('date', [$r['from'], $r['to']])
                        ->get();
        }
        else
        {
            $sells = DB::table('sell')->where('payment_method','>',1)
                        ->where('outlet',$r['outlet'])
                        ->whereBetween('date', [$r['from'], $r['to']])
                        ->get();
        }
        
        foreach($sells as $sell){
            if($sell->payment_method==4){
                $ret['Bkash'] += $sell->paid;
            }
            else if($sell->payment_method==5){
                $ret['Rocket'] += $sell->paid;
            }
            else if($sell->payment_method==6){
                $ret['City Amex'] += $sell->paid;
            }
            else if($sell->payment_method==7){
                $ret['DBBL'] += $sell->paid;
            }
            else if($sell->payment_method==9){
                $ret['UCB'] += $sell->paid;
            }
            else if($sell->payment_method==10){
                $ret['Nexus'] += $sell->paid;
            }
            else if($sell->payment_method==11){
                $ret['UKash'] += $sell->paid;
            }
            else if($sell->payment_method==15){
                $ret['Nagad'] += $sell->paid;
            }
            else if($sell->payment_method==8){
                /// For Dual
                if($sell->payment_method2==4){
                    $ret['Bkash'] += $sell->paid2;
                }
                else if($sell->payment_method2==5){
                    $ret['Rocket'] += $sell->paid2;
                }
                else if($sell->payment_method2==6){
                    $ret['City Amex'] += $sell->paid2;
                }
                else if($sell->payment_method2==7){
                    $ret['DBBL'] += $sell->paid2;
                }
                else if($sell->payment_method2==9){
                    $ret['UCB'] += $sell->paid2;
                }
                else if($sell->payment_method2==10){
                    $ret['Nexus'] += $sell->paid2;
                }
                else if($sell->payment_method2==11){
                    $ret['UKash'] += $sell->paid2;
                }
                else if($sell->payment_method2==15){
                    $ret['Nagad'] += $sell->paid2;
                }
                
                if($sell->payment_method3==4){
                    $ret['Bkash'] += $sell->paid3;
                }
                else if($sell->payment_method3==5){
                    $ret['Rocket'] += $sell->paid3;
                }
                else if($sell->payment_method3==6){
                    $ret['City Amex'] += $sell->paid3;
                }
                else if($sell->payment_method3==7){
                    $ret['DBBL'] += $sell->paid3;
                }
                else if($sell->payment_method3==9){
                    $ret['UCB'] += $sell->paid3;
                }
                else if($sell->payment_method3==10){
                    $ret['Nexus'] += $sell->paid3;
                }
                else if($sell->payment_method3==11){
                    $ret['UKash'] += $sell->paid3;
                }
                else if($sell->payment_method3==15){
                    $ret['Nagad'] += $sell->paid3;
                }
            }
        }
        //dd($ret);
        $data = [ 'data' => $ret,'type' => $r['type'],'code' => 'All','r'=>$r];
        $pdf = PDF::loadView('finalreport', $data,[],[
                'format' => 'A4',
                ]);
        
        return $pdf->stream($r['from'].' to '.$r['to'].'-'.$r['type'].'-report.pdf');
        
    }
    
    public function calculatePriceTotal(){
        $sells = Sell::where('price_total',0)->get();
        foreach($sells as $s){
            $sid = $s->id;
            $price_total = 0;
            foreach($s->items as $item){
                $price_total += (float)$item['price'];
            }
            DB::table('sell')
              ->where('id', $sid)
              ->update(['price_total' => $price_total]);
        }
    }
}
