<?php

namespace App\Http\Controllers\api\v1\payroll;

use App\Http\Controllers\Controller;
use App\Models\Balance;
use App\Models\Expense;
use App\Models\Outlet;
use App\Models\P_Attendance;
use App\Models\P_DailyReport;
use App\Models\P_Employee;
use App\Models\P_Leave;
use App\Models\P_Loan;
use App\Models\P_LoanPaid;
use App\Models\P_SalaryPosting;
use App\Models\P_YearMonth;
use App\Models\Production;
use App\Models\Production_Category;
use App\User;
use Illuminate\Http\Request;
use Carbon\Carbon;
use PDF;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Date;
use Illuminate\Support\Facades\DB;
use Symfony\Contracts\Service\Attribute\Required;

class PayrollController extends Controller
{
    public function utility_fn($from='',$to=''){
        if($from=='' || $to==''){
            $from = date("Y-m-01");     
            $to = date("Y-m-d", strtotime("+1 day"));
        }
        $to = date($to, strtotime("+1 day"));
        $group = Auth::user()->group_id;
        $outlet = Auth::user()->outlet;

        if($group==1 || $group==2){
            
            $r['employees'] = P_Employee::all();
            $r['outlets'] = $r['outlets'] = Outlet::where('id','!=',0)->get();
            $r['leaves'] = P_Leave::whereBetween('entry_at', [$from, $to])
            ->with([
                'employee'=> function($query) {
                    $query->select('id','name');
                }, 
                'outlet'=> function($query) {
                    $query->select('id','name');
                },
                'user'=> function($query) {
                    $query->select('id','username');
                },  
            ])->orderBy('entry_at','desc')->get();
            $r['dailyreports'] = P_DailyReport::
            select(DB::raw('yearmonth,emp_id,outlet,sum(overtime) as overtime,sum(late) as late,sum(present) as present,sum(tiffin) as tiffin '))
            ->whereBetween('entry_at', [$from, $to])
            ->with([
                'employee'=> function($query) {
                    $query->select('id','name');
                }, 
                'outlet'=> function($query) {
                    $query->select('id','name');
                }
            ])->groupBy('emp_id')->orderBy('outlet','asc')->get();

        }
        else{
            $r['outlets'] = Outlet::where('id',$outlet)->get();
            $r['employees'] = P_Employee::where('outlet',$outlet)->get();
            $r['leaves'] = P_Leave::where('outlet',$outlet)->whereBetween('entry_at', [$from, $to])
            ->with([
                'employee'=> function($query) {
                    $query->select('id','name');
                }, 
                'outlet'=> function($query) {
                    $query->select('id','name');
                },
                'user'=> function($query) {
                    $query->select('id','username');
                },  
            ])->orderBy('entry_at','desc')->get();
            $r['dailyreports'] = P_DailyReport::
            select(DB::raw('yearmonth,emp_id,outlet,sum(overtime) as overtime,sum(late) as late,sum(present) as present,sum(tiffin) as tiffin '))
            ->where('outlet',$outlet)
            ->whereBetween('entry_at', [$from, $to])
            ->with([
                'employee'=> function($query) {
                    $query->select('id','name');
                }, 
                'outlet'=> function($query) {
                    $query->select('id','name');
                }
            ])->groupBy('emp_id')->get();
            
        }
        $r['yearmonths'] = P_YearMonth::orderBy('entry_at','desc')->get();;
        
        
        return $r;
        

    }
    public function leaveentry(Request $request){
        $leave = new P_Leave();
        $emp = P_Employee::find($request->employee);
        $remains = $emp->vacation_remains;
        if($request->days <= $remains){
            $leave->yearmonth = $request->yearmonth;
            $leave->outlet = $request->outlet;
            $leave->emp_id = $request->employee;
            $leave->description = $request->remarks;
            $leave->days = $request->days;
            $leave->entry_by = Auth::user()->id;
            $leave->save();

            
            $emp->decrement('vacation_remains',$leave->days);
            $emp->save();
        }

        return $this->utility_fn();
    }
    public function get_init(){
        $group = Auth::user()->group_id;
        $outlet = Auth::user()->outlet;
        if($group==1 || $group==2){
            $ret['emp'] = P_Employee::all();
            $ret['accounts'] =  Balance::where('balance_method','!=',5)
                ->with([
                    'method'=> function($query) {
                        $query->select('id','name');
                    }, 
                    'outlet'=> function($query) {
                        $query->select('id','name');
                    }, 
                ])->orderBy('outlet','asc')->orderBy('balance_method','asc')->get();
        }
        else{
            $ret['emp'] = P_Employee::where('outlet',$outlet)->get();
            $ret['accounts'] =  Balance::where('balance_method','!=',5)->where('outlet',$outlet)
            ->with([
                'method'=> function($query) {
                    $query->select('id','name');
                }, 
                'outlet'=> function($query) {
                    $query->select('id','name');
                }, 
            ])->orderBy('outlet','asc')->orderBy('balance_method','asc')->get();
        }
        
        $ret['yearmonth'] = P_YearMonth::all();
        $ret['production_cat'] = Production_Category::all();
        return $ret;
    }
    public function last_punch(){
        $empl = P_Employee::where('uid',Auth::user()->id)->first();
        if($empl){
            $eid = $empl->id;
            $r = ['emp'=>'yes'];
            $r['att'] = P_Attendance::where('emp_id','=',$eid)->orderBy('pinged_at','desc')->first();
            return $r;
        }
        else return ['emp'=>'no'];
        
    }
    private function cron_punch($eid){
        $last_ping = P_Attendance::where('emp_id','=',$eid)->where('date','=',date("Y-m-d"))->orderBy('pinged_at','desc')->first();
        if($last_ping){
            if($last_ping->type == 1){
                $employee = P_Employee::where('id',$eid)->first();
                $check_out_time = $employee->check_out_time;
                $att = new P_Attendance();
                $att->emp_id = $eid;
                $att->type = -1; 
                $att->medium = 'auto_gen';
                $att->date = date('Y-m-d');
                $att->pinged_at = date('Y-m-d').' '.$check_out_time;
                $att->ip = '127.0.0.1';
                $att->save();
                //return P_Attendance::where('emp_id','=',$eid)->orderBy('pinged_at','desc')->first();
            }
            
        }

    }
    public function attendance_punch(){

        $empl = P_Employee::where('uid',Auth::user()->id)->first();
        $eid = $empl->id;
        $last_ping = P_Attendance::where('emp_id','=',$eid)->orderBy('pinged_at','desc')->first();
        $ping_type = -1;
        if(is_null($last_ping)) $ping_type = 1;
        else if($last_ping->type == -1) $ping_type = 1;
        
        $att = new P_Attendance();
        $att->emp_id = $eid;
        $att->type = $ping_type; 
        $att->medium = 'emp_id';
        $att->date = date('Y-m-d');
        $att->ip = request()->ip();
        $att->save();
        return P_Attendance::where('emp_id','=',$eid)->orderBy('pinged_at','desc')->first();

    }
    public function live_attendance(Request $request){
        $begin = new \DateTime( $request->from );
        $end   = new \DateTime( $request->to );
        $eid = $request->employee;
        $retEmp = [];
        $retDate = [];
        $employees = P_Employee::all();
        $retEmp = [];

        foreach ($employees as $key => $employee) {
            $att['att'] = P_Attendance::where('emp_id',$employee->id)->whereBetween('date', [$request->to, $request->to])->orderBy('pinged_at','asc')->get();
            $att['emp'] = $employee;
            array_push($retEmp,$att);
        }

        for($i = $begin; $i <= $end; $i->modify('+1 day')){
            $date =  $i->format("Y-m-d");
            $att2['date'] = $date;
            $att2['report'] = P_Attendance::where('emp_id',$eid)->where('date',$date)->orderBy('pinged_at','asc')->get();
            array_push($retDate,$att2);
        }
        
        $r['employeewise'] = $retEmp;
        $r['datewise'] = $retDate;
        return $r;
    }
    public function daily_report(){
        $date = date("Y-m-d");
        $employees = P_Employee::all();
        $retEmployees = [];
        foreach ($employees as $k => $emp) {
            $this->cron_punch($emp->id);
        }
        foreach ($employees as $k => $emp) {
            $sEmployee = $this->indv_daily_report($emp,$date);
        }
        
        //return $retEmployees;
    }

    private function indv_daily_report($emp,$date){
        //echo $emp->id;
        $employee = $emp;
        $eid = $emp->id;
        $pings_in = P_Attendance::where('emp_id',$eid)->where('date',$date)->where('type',1)->orderBy('pinged_at','desc')->get();
        $pings_out = P_Attendance::where('emp_id',$eid)->where('date',$date)->where('type',-1)->orderBy('pinged_at','desc')->get();
        $totalPingsIn = count($pings_in);
        //$totalPingsOut = count($pings_out);
        $report = null;
        $repExisting = P_DailyReport::where('emp_id',$eid)->where('r_date',$date)->first();
        if($repExisting) $report = $repExisting;
        else $report = new P_DailyReport();
        //Calculate Present
        if($totalPingsIn>0) $report->present = 1;
        else $report->present = 0;
        //Calculate Late
        if($report->present==1){ // Means present today
            // $first_punch = Carbon::createFromFormat('Y-m-d H:i:s', $pings_in[($totalPingsIn-1)]->pinged_at);
            // $should_punch = Carbon::createFromFormat('Y-m-d H:i:s', $date.' '.$employee->check_in_time);
            // if($first_punch->gt($should_punch)) $report->late = 1;
            // else $report->late = 0;


            //// Late count not done

            $report->check_in_time = $pings_in[($totalPingsIn-1)]->pinged_at;
            $report->check_out_time = $pings_out[0]->pinged_at;

            $should_check_out_time = strtotime($date.' '.$employee->check_out_time);
            $actual_check_out_time = strtotime($report->check_out_time);
            $diff = $should_check_out_time - $actual_check_out_time; // Tiffin
            if(($diff/60) < 60) $report->tiffin = 1;

            //Overtime
            $diff2 = ($actual_check_out_time - $should_check_out_time)/60;
            if($diff2 > 0) $report->overtime = $diff2;
            else $report->overtime = 0;


            // Calculate Late
            $should_check_in_time = strtotime($date.' '.$employee->check_in_time);
            $actual_check_in_time = strtotime($report->check_in_time);
            $late_diff = ($actual_check_in_time - $should_check_in_time)/60;
            if($late_diff <0) $report->late = 0;
            else $report->late = $late_diff;

        }
        else $report->late = 0;

        //Calculate Tiffin
        //Calculate Overtime
        $report->yearmonth = substr($date,0,4).substr($date,5,2);
        $report->r_date = $date;
        $report->outlet = $employee->outlet;
        $report->emp_id = $employee->id;
        $report->save();
        //echo 'success';
        return $report;
    }
    private function calculate_production_based_salary($eid,$ymon){

        $daily_report = P_DailyReport::select(DB::raw('emp_id,sum(overtime) as overtime,sum(late) as late,sum(present) as present,sum(tiffin) as tiffin '))
                            ->where('emp_id',$eid)->where('yearmonth',$ymon)->first();
                            
        $allowances = [];
        $deductions = [];
        $productions = Production::where('yearmonth','=',null)->where('emp_id',$eid)->get();

        //Tiffin
        $tiffin_am = 15;
        $item['name'] = 'Tiffin';
        $item['description'] = 'Total Tiffin '.($daily_report->tiffin).' Days';
        $item['softval'] = number_format($daily_report->tiffin * $tiffin_am,2, '.', '');
        $item['amount'] = number_format($daily_report->tiffin * $tiffin_am,2, '.', '');
        array_push($allowances,$item);
        //Award
        $item['name'] = 'Award';
        $item['description'] = 'No Award Given';
        $item['softval'] = 0;
        $item['amount'] = 0;
        array_push($allowances,$item);

        foreach ($productions as $key => $prod) {
            $category = Production_Category::where('id',$prod->category)->first();
            $item['name'] = $category->name;
            $item['description'] = 'Total '.$prod->quantity.' Pc. '.$category->rate.'/- Per Pc';
            $item['softval'] = $prod->quantity*$category->rate;
            $item['amount'] = $prod->quantity*$category->rate;
            array_push($allowances,$item);
        }

        //Loan Deduction
        $loan = P_Loan::select(DB::raw('emp_id, (sum(amount) - sum(paid)) as amount'))
        ->where('emp_id',$eid)->first();
        $item['name'] = 'Loan Deduction';
        $item['description'] = 'Loan : '.$loan->amount.' BDT';
        $item['softval'] = number_format($loan->amount,2, '.', '');
        $item['amount'] = number_format($loan->amount,2, '.', '');
        array_push($deductions,$item);

        //Other Punishment
        $item['name'] = 'Other Punishment';
        $item['description'] = 'No other punishment';
        $item['softval'] = 0.00;
        $item['amount'] = 0.00;
        array_push($deductions,$item);

        $ret['allowances'] = $allowances;
        $ret['deductions'] = $deductions;
        return $ret;
    }
    public function sal_posting_calculate(Request $request){
        $eid = $request['eid'];
        $ymon = $request['yearmonth'];


        $already = P_SalaryPosting::where('yearmonth',$ymon)->where('emp_id',$eid)->first();
        if($already){
            $ret['allowances'] = $already->items['allowances'];
            $ret['deductions'] = $already->items['deductions'];
            $ret['status'] = $already;
            $ret['status']['entry_by'] = User::where('id',$already->entry_by)->pluck('username');
            return $ret;
        }

        
        $allowances = [];
        $deductions = [];

        $employee = P_Employee::where('id',$eid)->first();
        if($employee->type=='production') return $this->calculate_production_based_salary($eid,$ymon);
        $yearmonth = P_YearMonth::where('yearmonth',$ymon)->first();
        
        $daily_report = P_DailyReport::select(DB::raw('emp_id,sum(overtime) as overtime,sum(late) as late,sum(present) as present,sum(tiffin) as tiffin '))
                            ->where('emp_id',$eid)->where('yearmonth',$ymon)->first();
        //$loan_remains = 0;
        //array_push($allowances,$daily_report);
        $checkInTime = strtotime(date('Y-m-d ').$employee->check_in_time);
        $checkOutTime = strtotime(date('Y-m-d').$employee->check_out_time);
        $daily_minutes = abs($checkInTime-$checkOutTime)/60; // Per day employee should work     
        
        
        //$days_of_this_month = cal_days_in_month(CAL_GREGORIAN,substr($ymon,4,2),substr($ymon,0,4));
        
        $tmpd = Carbon::createFromDate(substr($ymon,0,4), substr($ymon,4,2), 1);
        $days_of_this_month = $tmpd->daysInMonth;
        
        $one_minute_salary = ((float)$employee->salary) / ($daily_minutes*$days_of_this_month);
        //$one_minute_salary = ((float)$employee->salary) / ($daily_minutes*$yearmonth->working_days);
        $one_day_salary = $one_minute_salary * $daily_minutes;
        //array_push($allowances,$one_minute_salary);
        //Allowances
        //Basic
        $item['name'] = 'Basic Salary';
        $item['description'] = 'Monthly Approved Salary';
        $item['softval'] = $employee->salary;
        $item['amount'] = $employee->salary;
        array_push($allowances,$item);
        //Overtime
        //if($yearmonth->overtime > 0){ // Calculate overtime this month
            $item['name'] = 'Overtime';
            $item['description'] = 'Total Overtime '.($daily_report->overtime/60).' Hours. Overtime Rate: '.$yearmonth->overtime_rate;
            $item['softval'] = number_format($daily_report->overtime * $one_minute_salary * $yearmonth->overtime_rate,2, '.', '');
            $item['amount'] = number_format($daily_report->overtime * $one_minute_salary * $yearmonth->overtime_rate,2, '.', '');
            array_push($allowances,$item);
        //}
        //Tiffin
        $tiffin_am = 15;
        if($employee->type=='monthly') $tiffin_am = 20;
        $item['name'] = 'Tiffin';
        $item['description'] = 'Total Tiffin '.($daily_report->tiffin).' Days';
        $item['softval'] = number_format($daily_report->tiffin * $tiffin_am,2, '.', '');
        $item['amount'] = number_format($daily_report->tiffin * $tiffin_am,2, '.', '');
        array_push($allowances,$item);
        //Award
        $item['name'] = 'Award';
        $item['description'] = 'No Award Given';
        $item['softval'] = 0;
        $item['amount'] = 0;
        array_push($allowances,$item);
        //BONUS
        $item['name'] = 'Bonus';
        $item['description'] = 'No Bonus';
        $item['softval'] = 0;
        $item['amount'] = 0;
        array_push($allowances,$item);

        //array_push($allowances,$daily_report);

        //Deductions
        // Absent Deduction
        // $leave = P_Leave::select(DB::raw('emp_id, sum(days) as days'))
        // ->where('yearmonth',$ymon)->where('emp_id',$eid)->where('status','approved')->first();

        $loan = P_Loan::select(DB::raw('emp_id, (sum(amount) - sum(paid)) as amount'))
        ->where('emp_id',$eid)->first();
        
        $total_absent = 0;
        // $this_month_leave = Total approved leave of this month
        $this_month_leave = P_Leave::where('yearmonth',$ymon)->where('emp_id',$eid)->sum('days');
        $total_absent = $yearmonth->working_days - ((int)$daily_report->present + $this_month_leave);
        // if($leaves) $this_month_leave = (int)$leaves->days;
        // else $this_month_leave = 0;

        // if($vac_remains >= $this_month_leave){
        //     $new_vac_remain = $vac_remains - $this_month_leave;
        //     $total_absent = $yearmonth->working_days - ((int)$daily_report->present + $this_month_leave);
        // }
        // else{
        //     $new_vac_remain = 0;
        //     $total_absent = $yearmonth->working_days - ((int)$daily_report->present +  $employee->vacation_remains);
            
        // }

        if($total_absent > 0){
            $item['name'] = 'Absent Punishment';
            $item['vac_remains'] = 'Total approved leave: '.$this_month_leave;
            $t = 'Absent: '.$total_absent.' D, '.number_format($one_day_salary,2, '.', '').'/- Per Day. Present: '.$daily_report->present.' D, Leave: '.$this_month_leave.' D';
            $item['description'] = $t.'. Rate: '.$yearmonth->hourly_punishment_rate;
            $item['softval'] = number_format($total_absent*$one_day_salary*$yearmonth->hourly_punishment_rate,2, '.', '');
            $item['amount'] = number_format($total_absent*$one_day_salary*$yearmonth->hourly_punishment_rate,2, '.', '');
            array_push($deductions,$item);
        }
        else{
            $item['name'] = 'Absent Punishment';
            $item['description'] = '100% Present';
            $item['softval'] = 0;
            $item['amount'] = 0;
            $item['vac_remains'] = 'Total approved leave: '.$this_month_leave;
            array_push($deductions,$item);
        }
        //Late Punishment
        $item['name'] = 'Late Punishment';
        $item['description'] = 'Late : '.$daily_report->late.' Minutes. Rate: '.$yearmonth->late_rate;
        $item['softval'] = number_format($daily_report->late*$one_minute_salary*$yearmonth->late_rate,2, '.', '');
        $item['amount'] = number_format($daily_report->late*$one_minute_salary*$yearmonth->late_rate,2, '.', '');
        array_push($deductions,$item);

        //Loan Deduction
        $item['name'] = 'Loan Deduction';
        $item['description'] = 'Loan : '.$loan->amount.' BDT';
        $item['softval'] = number_format($loan->amount,2, '.', '');
        $item['amount'] = number_format($loan->amount,2, '.', '');
        array_push($deductions,$item);

        //Other Punishment
        $item['name'] = 'Other Punishment';
        $item['description'] = 'No other punishment';
        $item['softval'] = 0.00;
        $item['amount'] = 0.00;
        array_push($deductions,$item);

        $ret['allowances'] = $allowances;
        $ret['deductions'] = $deductions;
        //$ret['status'] = P_SalaryPosting::where('yearmonth',$ymon)->where('emp_id',$eid)->first();
        return $ret;

    }

    public function setPosting(Request $request){
        // $posting = null;
        // $checks = P_SalaryPosting::where('yearmonth',$request['yearmonth'])->where('emp_id',$request['eid'])->first();
        // if($checks){
        //     $posting = P_SalaryPosting::find($checks->id);
        // }
        // else{
        //     $posting = new P_SalaryPosting();
        // }
        $posting = new P_SalaryPosting();
        $posting->posting_no = 'PAYROLL-'.(string)$request['yearmonth'].(string)$request['outlet'].(string)$request['eid'];
        $posting->yearmonth = $request['yearmonth'];
        $posting->outlet = $request['outlet'];
        $posting->emp_id = $request['eid'];
        $posting->items = $request['items'];
        $posting->net_payable = $request['net'];
        $posting->status = $request['status'];
        $posting->entry_by = Auth::user()->id;
        $posting->save();

        $emp = P_Employee::where('id',$request['eid'])->first();
        
        
        //Expense Entry
        $bal = Balance::find($request['account']);

        $expense = new Expense();
        $expense->expense_sector = 3;
        $expense->outlet = $request['outlet'];
        $expense->method = $bal->balance_method;
        $expense->receipt_no = $posting->posting_no;
        $expense->status = 'Pending';
        $expense->from_balance = $request['account'];
        $expense->amount = $request['net'];
        $expense->remarks = 'Salary Posting of '.$emp->name.' Yearmonth-'.$request['yearmonth'];
        $expense->entry_by = Auth::user()->id;
        $expense->save();

        //decrement from balance
        $from = Balance::find($request['account']);
        $from->decrement('amount',$request['net']);
        $acc_outlet = $from->outlet;
        $from->save();
        //To frozen balance
        $to = Balance::where('outlet',$acc_outlet)->where('balance_method',5)->first();
        if($to){
            $to_frozen = Balance::find($to->id);
            $to_frozen->increment('amount',$request['net']);
            $to_frozen->save();
        }
        else{
            $bal = new Balance();
            $bal->outlet = $acc_outlet;
            $bal->amount = $request['net'];
            $bal->balance_method = 5;
            $bal->method_name = 'Frozen Balance';
            $bal->entry_by = 1;
            $bal->save();
        }

        
        

    }
    

    public function printSallarySheet($ymon,$eid){
        // $data['order'] = Order::where('order_no','=', $order)->first();
        // $data['payment'] = Payment::where('order_no','=', $order)->first();
        // $data['customer'] = Customer::where('id','=', $data['order']->customer)->first();
        // $data['outlet'] = Outlet::where('id','=',$data['order']->outlet)->first();
        // $data['creator'] = User::where('id','=',$data['order']->entry_by)->first();
        $data['salary'] = P_SalaryPosting::where('yearmonth',$ymon)->where('emp_id',$eid)->first();
        $data['employee'] = P_Employee::where('id',$eid)->first();
        $pdf = PDF::loadView('salarycert', $data,[],[
            'format' => 'A4',
            //'default_font' => 'blueerp',
            'mode' => 'utf-8',
            'margin_left' => '14',
            'margin_right' => '14',
            'margin_top' => '20',
            'margin_bottom' => '20'

          ]);
        return $pdf->stream($data['salary']->yearmonth.$eid.'-Salary Certificate.pdf');
    }
}
