<?php

namespace App\Http\Controllers\api\v1\common;

use App\Http\Controllers\Controller;
use App\Models\Balance;
use App\Models\Productarchive;
use App\Models\Expense;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

use App\Models\Outlet;
use App\Models\Sell;

class DashboardController extends Controller
{
    public function initdata()
    {
        $this->calculatePriceTotal();// Refresh Data

        if(Auth::user()->group_id<3) return $this->admindata();
        $oid = Auth::user()->outlet;

        $r = DB::table('stock_transfer')
                        ->select(DB::raw('COUNT(transfer_code) as total'))
                        ->where([
                                    ['transfer_to','=',$oid],
                                    ['status','=','0']
                                ])->get();
        $ret['pending_products'] = $r[0]->total;

        // $r = DB::select(DB::raw('SELECT count(a.code) as total_product, SUM(a.code_counter) as total_barcode From
        // (SELECT code, count(code) as code_counter FROM `product_archive` WHERE status =3 AND outlet_id = '.$oid.' GROUP by code) a;'));

        // $ret['current_stock'] = $r[0]->total_barcode;
        // $ret['available_products'] = $r[0]->total_product;
        
        $results = Productarchive::where('status', 3)
            ->where('outlet_id', $oid)
            ->groupBy('code')
            ->selectRaw('code, count(code) as code_counter')
            ->get();
        
        $totalBarcode = $results->sum('code_counter');
        $totalProducts = $results->count();
        
        $ret['current_stock'] = $totalBarcode;
        $ret['available_products'] = $totalProducts;
        
        $r = DB::table('sell')
                        ->select(DB::raw('COUNT(invoice_no) as total'))
                        ->where([
                                    ['outlet', '=', $oid],
                                    ['date', '=', date("Y-m-d")],
                                ])
                        ->get();
        $ret['todays_sell'] = $r[0]->total;

        $r = DB::table('sell')
                        ->select(DB::raw('SUM(payable) as total'))
                        ->where([
                                    ['outlet', '=', $oid],
                                    ['date', '=', date("Y-m-d")],
                                ])
                        ->get();
        $ret['todays_sell_amount'] = $r[0]->total;

        $r = DB::table('sell')
                        ->select(DB::raw('SUM(JSON_LENGTH(items)) as total'))
                        ->where([
                                    ['outlet', '=', $oid],
                                    ['date', '=', date("Y-m-d")],
                                ])
                        ->get();
        $ret['todays_sell_qtt'] = $r[0]->total;

        $r = DB::table('product_returns')
                        ->select(DB::raw('COUNT(receipt_no) as total'))
                        ->where([
                                    ['outlet', '=', $oid],
                                    ['date', '=', date("Y-m-d")],
                                ])
                        ->get();
        $ret['todays_return'] = $r[0]->total;

        $r = DB::table('product_returns')
                        ->select(DB::raw('SUM(JSON_LENGTH(items)) as total'))
                        ->where([
                                    ['outlet', '=', $oid],
                                    ['date', '=', date("Y-m-d")],
                                ])
                        ->get();
        $ret['todays_return_qtt'] = $r[0]->total;

        $r = DB::table('product_returns')
                        ->select(DB::raw('SUM(paid) as total'))
                        ->where([
                                    ['outlet', '=', $oid],
                                    ['date', '=', date("Y-m-d")],
                                ])
                        ->get();
        $ret['todays_return_amount'] = $r[0]->total;

        $r = Balance::select(DB::raw('*'))
                        ->with([
                            'method'=> function($query) {
                                $query->select('id','name');
                            }, 
                            'outlet'=> function($query) {
                                $query->select('id','name');
                            }, 
                        ])
                        ->where([
                                    ['outlet', '=', $oid],
                                ])
                        ->get();
        $ret['balance'] = $r;

        $r = DB::table('sell')
                        ->select(DB::raw('*'))
                        ->where([
                                    ['date', '=', date("Y-m-d")],
                                    ['outlet', '=', $oid],
                                ])
                        ->get();
        $ret['sell_summery'] = $r;

        $r = DB::table('product_returns')
                        ->select(DB::raw('*'))
                        ->where([
                                    ['date', '=', date("Y-m-d")],
                                    ['outlet', '=', $oid],
                                ])
                        ->get();
        $ret['return_summery'] = $r;




        return $ret;
    }
    public function calculatePriceTotal(){
        $sells = Sell::where('price_total',0)->get();
        foreach($sells as $s){
            $sid = $s->id;
            $price_total = 0;
            foreach($s->items as $item){
                $price_total += (float)$item['price'];
            }
            Sell::where('id', $sid)
              ->update(['price_total' => $price_total]);
        }
    }

    public function admindata(){
        // $r = DB::select(DB::raw('SELECT count(a.code) as total_product, SUM(a.code_counter) as total_barcode From
        // (SELECT code, count(code) as code_counter FROM `product_archive` WHERE status =3 GROUP by code) a;'));
    

        // $ret['current_stock'] = $r[0]->total_barcode;
        // $ret['available_products'] = $r[0]->total_product;
        
        $results = Productarchive::where('status', 3)
            ->groupBy('code')
            ->selectRaw('code, count(code) as code_counter')
            ->get();
        
        $totalBarcode = $results->sum('code_counter');
        $totalProducts = $results->count();
        
        $ret['current_stock'] = $totalBarcode;
        $ret['available_products'] = $totalProducts;


        $r = DB::table('sell')
                        ->select(DB::raw('COUNT(invoice_no) as total'))
                        ->where([
                                    ['date', '=', date("Y-m-d")],
                                ])
                        ->get();
        $ret['todays_sell'] = $r[0]->total;

        $r = DB::table('sell')
                        ->select(DB::raw('SUM(payable) as total'))
                        ->where([
                                    ['date', '=', date("Y-m-d")],
                                ])
                        ->get();
        $ret['todays_sell_amount'] = $r[0]->total;

        $r = DB::table('product_returns')
                        ->select(DB::raw('COUNT(receipt_no) as total'))
                        ->where([
                                    ['date', '=', date("Y-m-d")],
                                ])
                        ->get();
        $ret['todays_return'] = $r[0]->total;

        $r = DB::table('product_returns')
                        ->select(DB::raw('SUM(paid) as total'))
                        ->where([
                                    ['date', '=', date("Y-m-d")],
                                ])
                        ->get();
        $ret['todays_return_amount'] = $r[0]->total;

        $r = Balance::select(DB::raw('SUM(amount) as amount, balance_method, outlet'))
            ->with([
                'method'=> function($query) {
                    $query->select('id','name');
                }, 
                'outlet'=> function($query) {
                    $query->select('id','name');
                }, 
            ])->groupByRaw('balance_method')->get();
        $ret['balance'] = $r;

        $r = DB::table('sell')
                        ->select(DB::raw('SUM(JSON_LENGTH(items)) as total'))
                        ->where([
                                    ['date', '=', date("Y-m-d")],
                                ])
                        ->get();
        $ret['todays_sell_qtt'] = $r[0]->total;

        $r = DB::table('product_returns')
                        ->select(DB::raw('SUM(JSON_LENGTH(items)) as total'))
                        ->where([
                                    ['date', '=', date("Y-m-d")],
                                ])
                        ->get();
        $ret['todays_return_qtt'] = $r[0]->total;

        $r = DB::table('product_returns')
                        ->select(DB::raw('SUM(JSON_LENGTH(items)) as total'))
                        ->where([
                                    ['date', '=', date("Y-m-d")],
                                ])
                        ->get();
        $ret['todays_return_qtt'] = $r[0]->total;

        $r = DB::table('profits')
                        ->select(DB::raw('SUM(amount) as total'))
                        ->get();
        $ret['todays_profit'] = $r[0]->total;


        //Outlet wise sell calculate
        // $outlets = DB::table('outlets')->select(DB::raw('*'))->where('id','<>',0)->get();
        // $outlet_wise_sell = [];
        // foreach ($outlets as $key => $outlet) {
        //     $outlet_wise_sell[$key]['id'] = $outlet->id;
        //     $outlet_wise_sell[$key]['name'] = $outlet->name;
        //     // POS Sell
        //     $rt = DB::table('sell')
        //     ->select(DB::raw('SUM(price_total) as total, SUM(vat) as vat, SUM(discount) as discount'))
        //     ->where([
        //         ['outlet', '=', $outlet->id]
        //     ])
        //     ->whereBetween('date', [date("Y-m-d"), date("Y-m-d")])
        //     ->get();
        //     $outlet_wise_sell[$key]['pos_sell'] = $rt[0]->total - $rt[0]->discount + $rt[0]->vat;
        //     // Order Sell
        //     $o_status = ['Confirmed','Packaged','Shipped','Delivered','Completed','Canceled'];
        //     $rt = DB::table('orders')
        //     ->select(DB::raw('SUM(sub_total) as subtotal, SUM(discount) as discount, SUM(delivery_fee) as deliveryfee, SUM(vat) as vat'))
        //     ->where([
        //         ['outlet', '=', $outlet->id],
        //     ])
        //     ->whereIn('status', $o_status)
        //     ->whereBetween('date', [date("Y-m-d"), date("Y-m-d")]) 
        //     ->get();
        //     $outlet_wise_sell[$key]['order_sell'] = $rt[0]->subtotal - $rt[0]->discount + $rt[0]->deliveryfee + $rt[0]->vat;
        //     // Cancelled Order Sell
        //     $rt = DB::table('orders')
        //     ->join('order_log', 'orders.order_no', '=', 'order_log.order_no')
        //     ->where('order_log.event', 'Canceled')
        //     ->whereBetween('order_log.date', [date("Y-m-d"), date("Y-m-d")])
        //     ->where('order_log.outlet', $outlet->id)
        //     ->select(
        //         DB::raw('SUM(orders.sub_total) as subtotal, SUM(orders.discount) as discount, SUM(orders.delivery_fee) as deliveryfee, SUM(orders.vat) as vat')
        //     )
        //     ->first();
        //     $outlet_wise_sell[$key]['order_cancelled'] = $rt->subtotal - $rt->discount + $rt->deliveryfee + $rt->vat;
        //     // Return
        //     $rt = DB::table('product_returns')
        //                 ->select(DB::raw('SUM(amount) as ret_total'))
        //                 ->where([
        //                     ['outlet', '=', $outlet->id]
        //                 ])
        //                 ->whereBetween('date', [date("Y-m-d"), date("Y-m-d")]) 
        //                 ->get();
        //     $outlet_wise_sell[$key]['return'] = (float)$rt[0]->ret_total;
        //     //Expenses
        //     $rt = Expense::
        //     select(DB::raw('SUM(amount) as total'))
        //     ->whereBetween('entry_at', [date("Y-m-d"), date("Y-m-d", strtotime("+1 day"))])
        //     ->where('outlet', $outlet->id)
        //     ->where('status', 'Approved')
        //     ->get();
        //     $outlet_wise_sell[$key]['expense'] = (float)$rt[0]->total;
        // }

        $ret['outlet_wise_sell'] = $this->_outlet_wise_sum(date("Y-m-d"),date("Y-m-d"));
        $ret['distribution']['total_prduction'] = $this->_totalProduction(date("Y-m-d"),date("Y-m-d"));
        $ret['distribution']['total_warehouse'] = $this->_totalWarehouse(date("Y-m-d"),date("Y-m-d"));
        $ret['distribution']['total_sold'] = $this->_totalSold(date("Y-m-d"),date("Y-m-d"));
        $ret['distribution']['total_order'] = $this->_totalOrderChannel(date("Y-m-d"),date("Y-m-d"));
        $ret['distribution']['total_transfer'] = $this->_totalTransferChannel(date("Y-m-d"),date("Y-m-d"));
        $ret['distribution']['total_damaged'] = $this->_totalDamaged(date("Y-m-d"),date("Y-m-d"));
        $ret['distribution']['total_outlet_stock'] = $this->_totalStock(date("Y-m-d"),date("Y-m-d"));

        $ret['chart_data'] = $this->dateWiseChart();



        return $ret;
    }
    
    public function dateWiseChart(){
        $ret['dates'] = [];
        $ret['pos'] = [];
        $ret['order'] = [];
        $ret['net'] = [];
        $today = Carbon::now();
        for ($i = 0; $i < 30; $i++) {
            $date = $today->copy()->subDays($i);
            array_push($ret['dates'],$date->format('jS M')); //'Y-m-d'
            
            //pos sell start
            $rt = DB::table('sell')
            ->select(DB::raw('SUM(price_total) as total, SUM(vat) as vat, SUM(discount) as discount'))
            ->whereBetween('date', [$date->format('Y-m-d'), $date->format('Y-m-d')])
            ->get();
            $pos_sell = (float)$rt[0]->total - (float)$rt[0]->discount + (float)$rt[0]->vat;
            
            $rt = DB::table('product_returns')
                        ->select(DB::raw('SUM(amount) as ret_total'))
                        ->whereBetween('date', [$date->format('Y-m-d'), $date->format('Y-m-d')]) 
                        ->get();
                        
            $pos_sell = $pos_sell - (float)$rt[0]->ret_total;
            array_push($ret['pos'],$pos_sell);
            //pos sell end
            
            // order sell start
            $o_status = ['Confirmed','Packaged','Shipped','Delivered','Completed','Canceled'];
            $rt = DB::table('orders')
            ->select(DB::raw('SUM(sub_total) as subtotal, SUM(discount) as discount, SUM(delivery_fee) as deliveryfee, SUM(vat) as vat'))
            ->whereIn('status', $o_status)
            ->whereBetween('date', [$date->format('Y-m-d'), $date->format('Y-m-d')]) 
            ->get();
            $order_sell = $rt[0]->subtotal - $rt[0]->discount + $rt[0]->deliveryfee + $rt[0]->vat;
            // order sell end
            
            // Cancelled Order Sell
            $rt = DB::table('orders')
            ->join('order_log', 'orders.order_no', '=', 'order_log.order_no')
            ->where('order_log.event', 'Canceled')
            ->whereBetween('order_log.date', [$date->format('Y-m-d'), $date->format('Y-m-d')])
            ->select(
                DB::raw('SUM(orders.sub_total) as subtotal, SUM(orders.discount) as discount, SUM(orders.delivery_fee) as deliveryfee, SUM(orders.vat) as vat')
            )
            ->first();
            $cancel_sell = $rt->subtotal - $rt->discount + $rt->deliveryfee + $rt->vat;
            $order_sell = $order_sell - $cancel_sell;
            // cancel end
            
            $net = $order_sell + $pos_sell;
            array_push($ret['order'],$order_sell);
            array_push($ret['net'],$net);
        }
        return $ret;
    }
    
    public function rangewise($from,$to){
        $ret = [];
        $ret['outlet_wise_sell'] = $this->_outlet_wise_sum($from,$to);
        $ret['distribution']['total_prduction'] = $this->_totalProduction($from,$to);
        $ret['distribution']['total_warehouse'] = $this->_totalWarehouse($from,$to);
        $ret['distribution']['total_sold'] = $this->_totalSold($from,$to);
        $ret['distribution']['total_order'] = $this->_totalOrderChannel($from,$to);
        $ret['distribution']['total_transfer'] = $this->_totalTransferChannel($from,$to);
        $ret['distribution']['total_damaged'] = $this->_totalDamaged($from,$to);
        $ret['distribution']['total_outlet_stock'] = $this->_totalStock($from,$to);
        return $ret;
    }
    
    private function _outlet_wise_sum($from,$to){
        //Outlet wise sell calculate
        $outlets = DB::table('outlets')->select(DB::raw('*'))->where('id','<>',0)->get();
        $outlet_wise_sell = [];
        foreach ($outlets as $key => $outlet) {
            $outlet_wise_sell[$key]['id'] = $outlet->id;
            $outlet_wise_sell[$key]['name'] = $outlet->name;
            // POS Sell
            $rt = DB::table('sell')
            ->select(DB::raw('SUM(price_total) as total, SUM(vat) as vat, SUM(discount) as discount'))
            ->where([
                ['outlet', '=', $outlet->id]
            ])
            ->whereBetween('date', [$from,$to])
            ->get();
            $outlet_wise_sell[$key]['pos_sell'] = $rt[0]->total - $rt[0]->discount + $rt[0]->vat;
            // Order Sell
            $o_status = ['Confirmed','Packaged','Shipped','Delivered','Completed','Canceled'];
            $rt = DB::table('orders')
            ->select(DB::raw('SUM(sub_total) as subtotal, SUM(discount) as discount, SUM(delivery_fee) as deliveryfee, SUM(vat) as vat'))
            ->where([
                ['outlet', '=', $outlet->id],
            ])
            ->whereIn('status', $o_status)
            ->whereBetween('date', [$from,$to]) 
            ->get();
            $outlet_wise_sell[$key]['order_sell'] = $rt[0]->subtotal - $rt[0]->discount + $rt[0]->deliveryfee + $rt[0]->vat;
            // Cancelled Order Sell
            $rt = DB::table('orders')
            ->join('order_log', 'orders.order_no', '=', 'order_log.order_no')
            ->where('order_log.event', 'Canceled')
            ->whereBetween('order_log.date', [$from,$to])
            ->where('order_log.outlet', $outlet->id)
            ->select(
                DB::raw('SUM(orders.sub_total) as subtotal, SUM(orders.discount) as discount, SUM(orders.delivery_fee) as deliveryfee, SUM(orders.vat) as vat')
            )
            ->first();
            $outlet_wise_sell[$key]['order_cancelled'] = $rt->subtotal - $rt->discount + $rt->deliveryfee + $rt->vat;
            // Return
            $rt = DB::table('product_returns')
                        ->select(DB::raw('SUM(amount) as ret_total'))
                        ->where([
                            ['outlet', '=', $outlet->id]
                        ])
                        ->whereBetween('date', [$from,$to]) 
                        ->get();
            $outlet_wise_sell[$key]['return'] = (float)$rt[0]->ret_total;
            //Expenses
            $fd = Carbon::createFromFormat('Y-m-d', $to);
            $rt = Expense::
            select(DB::raw('SUM(amount) as total'))
            ->whereBetween('entry_at', [$from, $fd->addDay()->format('Y-m-d')])
            ->where('outlet', $outlet->id)
            ->where('status', 'Approved')
            ->get();
            $outlet_wise_sell[$key]['expense'] = (float)$rt[0]->total;
        }

        return $outlet_wise_sell;
    }
    
    private function _totalProduction($from,$to){
        
        return Productarchive::whereBetween('entry_at', [
                            Carbon::parse($from)->startOfDay(),
                            Carbon::parse($to)->endOfDay()
                        ])
                        ->count();
    }
    
    private function _totalWarehouse($from,$to){
        
        return Productarchive::whereBetween('entry_at', [
                            Carbon::parse($from)->startOfDay(),
                            Carbon::parse($to)->endOfDay()
                        ])
                        ->where('transfer_statement','')
                        // ->where('outlet_id',1)
                        ->where('status',3)
                        ->count();
    }
    
    private function _totalStock($from,$to){
        
        return Productarchive::whereBetween('entry_at', [
                            Carbon::parse($from)->startOfDay(),
                            Carbon::parse($to)->endOfDay()
                        ])
                        ->where('outlet_id','!=',1)
                        ->where('status',3)
                        ->count();
    }
    
    private function _totalSold($from,$to){
        
        return Productarchive::whereBetween('entry_at', [
                            Carbon::parse($from)->startOfDay(),
                            Carbon::parse($to)->endOfDay()
                        ])
                        ->where('status',4)
                        ->count();
    }
    
    private function _totalOrderChannel($from,$to){
        
        return Productarchive::whereBetween('entry_at', [
                            Carbon::parse($from)->startOfDay(),
                            Carbon::parse($to)->endOfDay()
                        ])
                        ->where('status',71)
                        ->count();
    }
    private function _totalTransferChannel($from,$to){
        
        return Productarchive::whereBetween('entry_at', [
                            Carbon::parse($from)->startOfDay(),
                            Carbon::parse($to)->endOfDay()
                        ])
                        ->where('status',2)
                        ->count();
    }
    
    private function _totalDamaged($from,$to){
        
        return Productarchive::whereBetween('entry_at', [
                            Carbon::parse($from)->startOfDay(),
                            Carbon::parse($to)->endOfDay()
                        ])
                        ->where('status',99)
                        ->count();
    }
}
