<?php

namespace App\Http\Controllers\api\v1\balance;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB; 
use App\User;

use App\Models\Balance;
use App\Models\Balance_method;
use App\Models\BalanceAdd;
use App\Models\BalanceTransfer;
use App\Models\BalanceWithdraw;
use App\Models\Expense;

class BalanceController extends Controller
{
    public function balance_cron(){
        $balance = Balance::where('balance_method','!=',1)
                                ->where('balance_method','!=',5)
                                ->where('amount','>',0)
                                ->where('outlet','!=',1)
                            ->get();
        //dd($balance);
        DB::transaction(function () use ($balance) {
            foreach ($balance as $key => $bal) {
                $frm_bal = Balance::find($bal->id);
                $commission = Balance_method::find($frm_bal->balance_method)->commission;
                $r = [];
                $r['amount'] = $frm_bal->amount;
                $r['from'] = $frm_bal->balance_method;
                $r['from_balance_id'] = $bal->id;
                $r['from_outlet'] = $frm_bal->outlet;
                $r['remarks'] = date('Y-m-d').' Digital Payment Commission';
                $r['to'] = $frm_bal->balance_method;
                $r['to_outlet'] = 1;
                $r['commission'] = ((float)$frm_bal->amount * ((float)$commission/100));
                $r['from_cron'] = true;

                $request = new Request($r);

                $this->transfer($request);
            }
        });
    }

    public function getBalances($from='',$to=''){
        if($from=='' || $to==''){
            $from = date("Y-m-01");     
            $to = date("Y-m-d", strtotime("+1 day"));
        }
        $group = Auth::user()->group_id;
        $outlet = Auth::user()->outlet;
        $r['accounts'] = null;
        $r['allaccounts'] = null;
        if($group==1 || $group==2){
            $r['accounts'] =  Balance::select('id','balance_method','amount','outlet')
                ->with([
                    'method'=> function($query) {
                        $query->select('id','name');
                    }, 
                    'outlet'=> function($query) {
                        $query->select('id','name');
                    }, 
                ])->orderBy('outlet','asc')->orderBy('balance_method','asc')->get();

            
                $r['transfers'] = BalanceTransfer::select('id','from_method','to_method','from_outlet','to_outlet','amount','remarks','status','entry_by','entry_at','received_by','received_at')
                ->with([
                    'method'=> function($query) {
                        $query->select('id','name');
                    },
                    'r_method'=> function($query) {
                        $query->select('id','name');
                    }, 
                    'outlet'=> function($query) {
                        $query->select('id','name');
                    },
                    'to_outlet'=> function($query) {
                        $query->select('id','name');
                    }, 
                    'user'=> function($query) {
                        $query->select('id','username');
                    }, 
                    'r_user'=> function($query) {
                        $query->select('id','username');
                    }, 
                ])
                ->whereBetween('entry_at', [$from, $to])
                ->orderBy('entry_at','desc')->get();

                $r['withdraws'] = BalanceWithdraw::select('id','from_method','outlet','amount','remarks','entry_by','entry_at')
                ->with([
                    'method'=> function($query) {
                        $query->select('id','name');
                    },
                    'outlet'=> function($query) {
                        $query->select('id','name');
                    }, 
                    'user'=> function($query) {
                        $query->select('id','username');
                    },
                ])
                ->whereBetween('entry_at', [$from, $to])
                ->orderBy('entry_at','desc')->get();

                $r['adds'] = BalanceAdd::select('id','from_method','outlet','amount','remarks','entry_by','entry_at')
                ->with([
                    'method'=> function($query) {
                        $query->select('id','name');
                    },
                    'outlet'=> function($query) {
                        $query->select('id','name');
                    }, 
                    'user'=> function($query) {
                        $query->select('id','username');
                    },
                ])
                ->whereBetween('entry_at', [$from, $to])
                ->orderBy('entry_at','desc')->get();

                $r['receives'] = BalanceTransfer::select('id','from_method','to_method','from_outlet','amount','expense','remarks','status','entry_by','entry_at')
                ->with([
                    'method'=> function($query) {
                        $query->select('id','name');
                    },
                    'r_method'=> function($query) {
                        $query->select('id','name');
                    }, 
                    'outlet'=> function($query) {
                        $query->select('id','name');
                    }, 
                    'user'=> function($query) {
                        $query->select('id','username');
                    }, 
                ])
                ->where('to_outlet',1)
                ->where('status','Frozen')
                ->orderBy('entry_at','desc')->get();

            
        }
        else{
            $r['accounts'] =  Balance::select('id','balance_method','amount','outlet')
                ->where('outlet',$outlet)
                ->with([
                    'method'=> function($query) {
                        $query->select('id','name');
                    }, 
                    'outlet'=> function($query) {
                        $query->select('id','name');
                    }, 
                ])->orderBy('outlet','asc')->orderBy('balance_method','asc')->get();
            
            $r['transfers'] = BalanceTransfer::select('id','from_method','to_method','from_outlet','to_outlet','amount','remarks','status','entry_by','entry_at','received_by','received_at')
                ->whereBetween('entry_at', [$from, $to])
                ->whereRaw("(from_outlet = $outlet OR to_outlet = $outlet )")
                ->with([
                    'method'=> function($query) {
                        $query->select('id','name');
                    },
                    'r_method'=> function($query) {
                        $query->select('id','name');
                    }, 
                    'outlet'=> function($query) {
                        $query->select('id','name');
                    },
                    'to_outlet'=> function($query) {
                        $query->select('id','name');
                    }, 
                    'user'=> function($query) {
                        $query->select('id','username');
                    }, 
                    'r_user'=> function($query) {
                        $query->select('id','username');
                    }, 
                ])
                
                //->whereRaw("(from_outlet = $outlet OR to_outlet = $outlet )")
                ->orderBy('entry_at','desc')->get();


                $r['receives'] = BalanceTransfer::select('id','from_method','to_method','from_outlet','amount','remarks','status','entry_by','entry_at')
                ->with([
                    'method'=> function($query) {
                        $query->select('id','name');
                    },
                    'r_method'=> function($query) {
                        $query->select('id','name');
                    }, 
                    'outlet'=> function($query) {
                        $query->select('id','name');
                    }, 
                    'user'=> function($query) {
                        $query->select('id','username');
                    }, 
                ])
                ->where('to_outlet',Auth::user()->outlet)
                ->where('status','Frozen')
                ->orderBy('entry_at','desc')->get();
        }

        $r['allaccounts'] = Balance::select('id','balance_method','outlet')
        ->with([
            'method'=> function($query) {
                $query->select('id','name');
            }, 
            'outlet'=> function($query) {
                $query->select('id','name');
            }, 
        ])->orderBy('outlet','asc')->orderBy('balance_method','asc')->get();
        
        return $r;
        

    }

    public function transfer(Request $request){
        DB::transaction(function () use ($request) {
            //Transfer status
            $transfer = new BalanceTransfer;
            $transfer->to_method = $request->to;
            $transfer->from_method = $request->from;
            $transfer->from_outlet = $request->from_outlet;
            $transfer->to_outlet = $request->to_outlet;
            $transfer->amount = $request->amount;
            $transfer->expense = $request->commission;
            $transfer->remarks = $request->remarks;
            if(isset($request->from_cron)){
                $transfer->entry_by = 1;
            }
            else{
                $transfer->entry_by = Auth::user()->id;
            }
            
            $transfer->save();

            //decrement from balance
            $from = Balance::find($request->from_balance_id);
            $from->decrement('amount',$request->amount);
            $from->save();
            //To frozen balance
            $to = Balance::where('outlet',$request->from_outlet)->where('balance_method',5)->first();
            if($to){
                $to_frozen = Balance::find($to->id);
                $to_frozen->increment('amount',$request->amount);
                $to_frozen->save();
            }
            else{
                $bal = new Balance();
                $bal->outlet = $request->from_outlet;
                $bal->amount = $request->amount;
                $bal->balance_method = 5;
                $bal->method_name = 'Frozen Balance';
                $bal->entry_by = 1;
                $bal->save();
            }
        });

        if(isset($request->from_cron)){
           
        }
        else{
            return $this->getBalances();
        }
        
    }
    public function receive(Request $request){
        DB::transaction(function () use ($request) {
            $transfer = BalanceTransfer::find($request->id);
            $expense = (float)$request->expense;
            $receive = (float)$transfer->amount - $expense;
            if($request->type===true){

                $b = Balance::where('outlet',$transfer->from_outlet)->where('balance_method',5)->first();
                $from = Balance::find($b->id);
                $from->decrement('amount',$transfer->amount);
                $from->save();

                $b = Balance::where('outlet',$transfer->to_outlet)->where('balance_method',$transfer->to_method)->first();
                $from = Balance::find($b->id);
                $from->increment('amount',$receive);
                $from->save();

                $transfer->status = 'Received';
                $transfer->received_by = Auth::user()->id;
                $transfer->received_at = now();
                $transfer->save();

                // Expense Entry
                if($expense>0){
                    $b = Balance::where('outlet',$transfer->from_outlet)->where('balance_method',$transfer->from_method)->first();
                    
                    $exp = new Expense();
                    $exp->expense_sector = 99;
                    $exp->outlet = $transfer->from_outlet;
                    $exp->method = $transfer->from_method;
                    $exp->from_balance = $b->id;
                    $exp->status = 'Approved';
                    $exp->approved_by = Auth::user()->id;
                    $exp->approved_at = now();
                    $exp->amount = $expense;
                    $exp->remarks = $transfer->remarks;
                    $exp->entry_by = Auth::user()->id;
                    $exp->save();
                }
                
            }
            else{
                $b = Balance::where('outlet',$transfer->from_outlet)->where('balance_method',5)->first();
                $from = Balance::find($b->id);
                $from->decrement('amount',$transfer->amount);
                $from->save();

                $b = Balance::where('outlet',$transfer->from_outlet)->where('balance_method',$transfer->from_method)->first();
                $from = Balance::find($b->id);
                $from->increment('amount',$transfer->amount);
                $from->save();

                $transfer->status = 'Canceled';
                $transfer->received_by = Auth::user()->id;
                $transfer->received_at = now();
                $transfer->save();
            }
            
        });

        return $this->getBalances();
    }
    public function withdraw(Request $request){
        $withdraw = new BalanceWithdraw;

        $withdraw->from_method = $request->from;
        $withdraw->amount = $request->amount;
        $withdraw->outlet = $request->outlet;
        $withdraw->remarks = $request->remarks;
        $withdraw->entry_by = Auth::user()->id;

        $withdraw->save();

        $b = Balance::where('outlet',$request->outlet)->where('balance_method',$request->from)->first();
        $from = Balance::find($b->id);
        $from->decrement('amount',$request->amount);
        $from->save();

        return $this->getBalances();
    }

    public function add(Request $request){
        $add = new BalanceAdd();

        $add->from_method = $request->from;
        $add->amount = $request->amount;
        $add->outlet = $request->outlet;
        $add->remarks = $request->remarks;
        $add->entry_by = Auth::user()->id;

        $add->save();

        $b = Balance::where('outlet',$request->outlet)->where('balance_method',$request->from)->first();
        $from = Balance::find($b->id);
        $from->increment('amount',$request->amount);
        $from->save();

        return $this->getBalances();
    }
}