<?php

namespace App\Http\Controllers\api\v1\audit;

use App\Http\Controllers\Controller;
use App\Models\Outlet;
use App\Models\Productarchive;
use App\Models\ProductArchiveDecimalPricing;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use App\Models\Audit;
use App\Models\AuditLog;

class AuditController extends Controller
{   
    public function startAudit(Request $request)
    {
        $group = Auth::user()->group_id;
        if($group==1 || $group==2){
            $user = Auth::user();
            $outlet = $request->id;

            if ($outlet) {
                // Update products associated with the user's outlet
                Productarchive::where('outlet_id', $outlet)->update([
                    'audit_outlet_id' => 0,
                    'audit_outlet_name' => '',
                    'audit_at' => null,
                ]);
                $audit = new Audit();
                $audit->outlet_id = $outlet;
                $audit->audit_by = $user->id;
                $audit->start_at = now();
                $audit->status = 0;
                $audit->save();

                return response()->json(['message' => 'Audit started successfully']);
            } else {
                return response()->json(['error' => 'User is not associated with any outlet'], 404);
            }
        }
    }
    
    public function endAudit(Request $request)
    {
        ini_set('memory_limit', '-1');
        $group = Auth::user()->group_id;
        if($group==1 || $group==2){
            //$ignores = array_merge($return_codes,$pos_codes,$order_codes);
            $id = $request->id;
            $out = $request->outlet_id;
            
            
            
            //Productarchive::where('status',3)->where('audit_outlet_id',0)->update(['status' => 404]);
            //$remove_stocks = Productarchive::select('id', 'barcode', 'outlet_id', 'outlet_name')->where('status',3)->where('audit_outlet_id',0)->orderBy('outlet_id','asc')->get()->toArray();
            
            // Make sellable to all products
            $logs = AuditLog::where('audit_id',$id)->get()->toArray();
            foreach($logs as $log){
                $arcv = Productarchive::where('barcode',$log['barcode'])->get()->first();
                $p = Productarchive::find($arcv->id);
                
                $p->status = $log['new_status'];
                $p->outlet_id = $log['new_outlet_id'];
                $p->outlet_name = Outlet::find($log['new_outlet_id'])->name;
                $p->audit_outlet_id = 0;
                $p->audit_outlet_name = '';
                $p->audit_at = null;
                $p->save();
            }
            
            // now remove rest all sellable products which are not audited
            $audited_codes = collect($logs)->pluck('barcode')->toArray();
    
            $rest_p = Productarchive::select('id', 'barcode', 'audit_outlet_id', 'audit_outlet_name')
                    ->where('outlet_id',$out)
                    ->where('status',3)
                    ->whereNotIn('barcode', $audited_codes)
                    ->get()
                    ->toArray();
                    
            foreach ($rest_p as $singleProduct) {
                $sid = $singleProduct['id'];
                // Use the find method directly on the model to get an instance
                $row = Productarchive::find($sid);
                if ($row) {
                    $row->status = 840;
                    $row->save();
                }
            }
            
            $audit = Audit::find($id);
            $audit->end_at = now();
            $audit->status = 1;
            $audit->save();
            
            return response()->json(['message' => 'Audit ended successfully']);
        }
    }
    
    public function current($outlet_id){
        ini_set('memory_limit', '-1');
        //return Productarchive::select(DB::raw('id,barcode,outlet_id,outlet_name,audit_outlet_id,audit_outlet_name,audit_at'))->where('status',3)->orderBy('barcode','asc')->paginate(10);
        $group = Auth::user()->group_id;
        $outlet = $outlet_id;
        if($group==1 || $group==2){
            //return DB::select('SELECT * FROM `product_archive` WHERE audit_outlet_id<>0 AND outlet_id<>audit_outlet_id ORDER BY barcode ASC');
            //return DB::select('SELECT * FROM `product_archive` WHERE `status`=3 ORDER BY barcode ASC');
            
            $ret['running_audit'] = Audit::where('outlet_id',$outlet)->where('status',0)->get()->toArray();
            if(count($ret['running_audit'])>0){ // audit running...show all possible products
                $ret['barcodes'] = ProductArchiveDecimalPricing::select(DB::raw('id,barcode,outlet_id,outlet_name,audit_outlet_id,audit_outlet_name,audit_at,status,price'))
                                ->where(function ($query) use ($outlet) {
                                    $query->where('outlet_id',$outlet)
                                          ->where('status', 3);
                                })
                                ->orWhere('audit_outlet_id', $outlet)
                                ->orderBy('audit_at','desc')->get()->toArray();
                
            }
            else{ // Audit ended show current stock
                $ret['barcodes'] = ProductArchiveDecimalPricing::select(DB::raw('id,barcode,outlet_id,outlet_name,audit_outlet_id,audit_outlet_name,audit_at,status,price'))
                    ->where('outlet_id',$outlet)
                    ->where('status',3)
                    ->orderBy('entry_at','desc')->get()->toArray();
            }
            return $ret;
        }
        else{
            
            //$ret['barcodes'] = Productarchive::select(DB::raw('id,barcode,outlet_id,outlet_name,audit_outlet_id,audit_outlet_name,audit_at,status'))->where('status',3)->where('outlet_id',$outlet)->orWhere('audit_outlet_id',$outlet)->orderBy('barcode','asc')->get()->toArray();

            $ret['running_audit'] = Audit::where('outlet_id',$outlet)->where('status',0)->get()->toArray();
            if(count($ret['running_audit'])>0){ // audit running...show audited products only
                $ret['barcodes'] = ProductArchiveDecimalPricing::select(DB::raw('id,barcode,outlet_id,outlet_name,audit_outlet_id,audit_outlet_name,audit_at,status,price'))
                    ->where('audit_outlet_id',$outlet)
                    ->orderBy('audit_at','desc')->get()->toArray();
            }
            else{ // Audit ended show current stock
                $ret['barcodes'] = ProductArchiveDecimalPricing::select(DB::raw('id,barcode,outlet_id,outlet_name,audit_outlet_id,audit_outlet_name,audit_at,status,price'))
                    ->where('outlet_id',$outlet)
                    ->where('status',3)
                    ->orderBy('entry_at','desc')->get()->toArray();
            }
            return $ret;
        }
        
        //return $request;
    }
    public function audit_rollback(){
        $logs = AuditLog::all()->toArray();
        foreach($logs as $log){
            $arcv = Productarchive::where('barcode',$log['barcode'])->get()->first();
            $p = Productarchive::find($arcv->id);
            $p->status = $log['old_status'];
            $p->outlet_id = $log['old_outlet_id'];
            $p->outlet_name = Outlet::find($log['old_outlet_id'])->name;
            $p->audit_outlet_id = $log['new_outlet_id'];
            $p->audit_outlet_name = Outlet::find($log['new_outlet_id'])->name;
            $p->audit_at = $log['created_at'];
            $p->save();
        }
    }
    public function barcode_audit(Request $request){
        $outlet = Outlet::find(Auth::user()->outlet);
        $ret = [];
        $arch = Productarchive::where('barcode',$request->barcode)->first();
        if($arch){ //New Product
            $auditlog = new AuditLog();
            $auditlog->audit_id = $request->audit_id;
            $auditlog->barcode = $request->barcode;
            $auditlog->old_outlet_id = $arch->outlet_id;
            $auditlog->new_outlet_id = $outlet->id;
            $auditlog->old_status = $arch->status;
            $auditlog->new_status = 3;
            $auditlog->save();
            
            $arch->audit_outlet_id = $outlet->id;
            $arch->audit_outlet_name = $outlet->name;
            //$arch->outlet_id = $outlet->id;
            //$arch->outlet_name = $outlet->name;
            $arch->audit_at = now();
            //$arch->status = 3;
            $arch->save();
            $ret['message'] = $request->barcode.' Audited';
            $ret['barcode'] = $arch;
            $ret['status'] = 'success';
            
        }
        else{
            // Old Product
            // $ar = Productarchive::where(
            //     [
            //         'code'=>$request->barcode,
            //         'outlet_id'=>$outlet->id,
            //         'status'=>3
            //     ])->where('audit_outlet_id','!=',0)->first();
            // if($ar){ // Found in My Stock
            //     $ar->audit_outlet_id = $outlet->id;
            //     $ar->audit_outlet_name = $outlet->name;
            //     $ar->audit_at = now();
            //     $ar->status = 3;
            //     $ar->save();
            //     $ar['message'] = $ar->barcode.' Audited';
            //     return $ar;
            // }
            // else{ // Not Found In My Stock Collect From Others
            //     $arc = Productarchive::where(
            //         [
            //             'code'=>$request->barcode,
            //             'status'=>3
            //         ])->where('audit_outlet_id','!=',0)->first();
            //     if($arc){ // Found In Others Stock
            //         $arc->audit_outlet_id = $outlet->id;
            //         $arc->audit_outlet_name = $outlet->name;
            //         $arc->audit_at = now();
            //         $arc->status = 3;
            //         $arc->save();
            //         $arc['message'] = $ar->barcode.' Audited';
            //         return $ar;
            //     }
            //     else{
            //         return ['message'=>'No Suitable Barcode found in any stock. Please make a manual Audit.'];
            //     }
            // }
            $ret['message'] = 'No Suitable Barcode found in any stock. Please make a manual Audit for old products';
            $ret['barcode'] = $request;
            $ret['status'] = 'failed';
        }
        
        return $ret;
    }
}
